/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ChangeFeedOptions;
import com.azure.cosmos.CosmosAsyncConflict;
import com.azure.cosmos.CosmosAsyncContainerResponse;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncItem;
import com.azure.cosmos.CosmosAsyncItemResponse;
import com.azure.cosmos.CosmosAsyncScripts;
import com.azure.cosmos.CosmosConflictProperties;
import com.azure.cosmos.CosmosContainerProperties;
import com.azure.cosmos.CosmosContainerRequestOptions;
import com.azure.cosmos.CosmosItemProperties;
import com.azure.cosmos.CosmosItemRequestOptions;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.Resource;
import com.azure.cosmos.SqlQuerySpec;
import com.azure.cosmos.internal.Document;
import com.azure.cosmos.internal.DocumentCollection;
import com.azure.cosmos.internal.Offer;
import com.azure.cosmos.internal.RequestOptions;
import com.azure.cosmos.internal.ResourceResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosAsyncContainer {
    private CosmosAsyncDatabase database;
    private String id;
    private CosmosAsyncScripts scripts;

    CosmosAsyncContainer(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncContainer setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncContainerResponse> read() {
        return this.read(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosAsyncContainerResponse> read(CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().readCollection(this.getLink(), options.toRequestOptions()).map(response -> new CosmosAsyncContainerResponse((ResourceResponse<DocumentCollection>)response, this.database)).single();
    }

    public Mono<CosmosAsyncContainerResponse> delete(CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().deleteCollection(this.getLink(), options.toRequestOptions()).map(response -> new CosmosAsyncContainerResponse((ResourceResponse<DocumentCollection>)response, this.database)).single();
    }

    public Mono<CosmosAsyncContainerResponse> delete() {
        return this.delete(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosAsyncContainerResponse> replace(CosmosContainerProperties containerSettings) {
        return this.replace(containerSettings, null);
    }

    public Mono<CosmosAsyncContainerResponse> replace(CosmosContainerProperties containerSettings, CosmosContainerRequestOptions options) {
        Resource.validateResource(containerSettings);
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().replaceCollection(containerSettings.getV2Collection(), options.toRequestOptions()).map(response -> new CosmosAsyncContainerResponse((ResourceResponse<DocumentCollection>)response, this.database)).single();
    }

    public Mono<CosmosAsyncItemResponse> createItem(Object item) {
        return this.createItem(item, new CosmosItemRequestOptions());
    }

    public Mono<CosmosAsyncItemResponse> createItem(Object item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.database.getDocClientWrapper().createDocument(this.getLink(), CosmosItemProperties.fromObject(item), requestOptions, true).map(response -> new CosmosAsyncItemResponse((ResourceResponse<Document>)response, requestOptions.getPartitionKey(), this)).single();
    }

    public Mono<CosmosAsyncItemResponse> upsertItem(Object item) {
        return this.upsertItem(item, null);
    }

    public Mono<CosmosAsyncItemResponse> upsertItem(Object item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.getDatabase().getDocClientWrapper().upsertDocument(this.getLink(), CosmosItemProperties.fromObject(item), options.toRequestOptions(), true).map(response -> new CosmosAsyncItemResponse((ResourceResponse<Document>)response, requestOptions.getPartitionKey(), this)).single();
    }

    public Flux<FeedResponse<CosmosItemProperties>> readAllItems() {
        return this.readAllItems(new FeedOptions());
    }

    public Flux<FeedResponse<CosmosItemProperties>> readAllItems(FeedOptions options) {
        return this.getDatabase().getDocClientWrapper().readDocuments(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosItemProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public Flux<FeedResponse<CosmosItemProperties>> queryItems(String query) {
        return this.queryItems(new SqlQuerySpec(query), null);
    }

    public Flux<FeedResponse<CosmosItemProperties>> queryItems(String query, FeedOptions options) {
        return this.queryItems(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosItemProperties>> queryItems(SqlQuerySpec querySpec) {
        return this.queryItems(querySpec, null);
    }

    public Flux<FeedResponse<CosmosItemProperties>> queryItems(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getDatabase().getDocClientWrapper().queryDocuments(this.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponseWithQueryMetrics(CosmosItemProperties.getFromV2Results(response.getResults()), response.getResponseHeaders(), response.queryMetrics()));
    }

    public Flux<FeedResponse<CosmosItemProperties>> queryChangeFeedItems(ChangeFeedOptions changeFeedOptions) {
        return this.getDatabase().getDocClientWrapper().queryDocumentChangeFeed(this.getLink(), changeFeedOptions).map(response -> new FeedResponse<CosmosItemProperties>(CosmosItemProperties.getFromV2Results(response.getResults()), response.getResponseHeaders(), false));
    }

    public CosmosAsyncItem getItem(String id, Object partitionKey) {
        return new CosmosAsyncItem(id, partitionKey, this);
    }

    public CosmosAsyncScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosAsyncScripts(this);
        }
        return this.scripts;
    }

    public Flux<FeedResponse<CosmosConflictProperties>> readAllConflicts(FeedOptions options) {
        return this.database.getDocClientWrapper().readConflicts(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosConflictProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public Flux<FeedResponse<CosmosConflictProperties>> queryConflicts(String query) {
        return this.queryConflicts(query, null);
    }

    public Flux<FeedResponse<CosmosConflictProperties>> queryConflicts(String query, FeedOptions options) {
        return this.database.getDocClientWrapper().queryConflicts(this.getLink(), query, options).map(response -> BridgeInternal.createFeedResponse(CosmosConflictProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public CosmosAsyncConflict getConflict(String id) {
        return new CosmosAsyncConflict(id, this);
    }

    public Mono<Integer> readProvisionedThroughput() {
        return this.read().flatMap(cosmosContainerResponse -> this.database.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + cosmosContainerResponse.getProperties().getResourceId() + "'", new FeedOptions()).single()).flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "No offers found for the resource"));
            }
            return this.database.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(cosmosOfferResponse -> ((Offer)cosmosOfferResponse.getResource()).getThroughput());
    }

    public Mono<Integer> replaceProvisionedThroughput(int requestUnitsPerSecond) {
        return this.read().flatMap(cosmosContainerResponse -> this.database.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + cosmosContainerResponse.getProperties().getResourceId() + "'", new FeedOptions()).single()).flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "No offers found for the resource"));
            }
            Offer offer = (Offer)offerFeedResponse.getResults().get(0);
            offer.setThroughput(requestUnitsPerSecond);
            return this.database.getDocClientWrapper().replaceOffer(offer).single();
        }).map(offerResourceResponse -> ((Offer)offerResourceResponse.getResource()).getThroughput());
    }

    public CosmosAsyncDatabase getDatabase() {
        return this.database;
    }

    String URIPathSegment() {
        return "colls";
    }

    String parentLink() {
        return this.database.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }
}

