/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncConflict;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosConflictProperties;
import com.azure.cosmos.CosmosResponse;
import com.azure.cosmos.internal.Conflict;
import com.azure.cosmos.internal.ResourceResponse;

public class CosmosAsyncConflictResponse
extends CosmosResponse<CosmosConflictProperties> {
    private CosmosAsyncContainer container;
    private CosmosAsyncConflict conflictClient;

    CosmosAsyncConflictResponse(ResourceResponse<Conflict> response, CosmosAsyncContainer container) {
        super(response);
        this.container = container;
        if (response.getResource() == null) {
            super.setProperties(null);
        } else {
            super.setProperties(new CosmosConflictProperties(response.getResource().toJson()));
            this.conflictClient = new CosmosAsyncConflict(response.getResource().getId(), container);
        }
    }

    CosmosAsyncContainer getContainer() {
        return this.container;
    }

    public CosmosAsyncConflict getConflict() {
        return this.conflictClient;
    }

    @Override
    public CosmosConflictProperties getProperties() {
        return this.getProperties();
    }
}

