/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.RetryOptions;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;

public final class ConnectionPolicy {
    private static final int DEFAULT_REQUEST_TIMEOUT_IN_MILLIS = 60000;
    private static final int DEFAULT_MEDIA_REQUEST_TIMEOUT_IN_MILLIS = 300000;
    private static final int DEFAULT_IDLE_CONNECTION_TIMEOUT_IN_MILLIS = 60000;
    private static final int DEFAULT_MAX_POOL_SIZE = 1000;
    private static ConnectionPolicy default_policy = null;
    private int requestTimeoutInMillis = 60000;
    private int mediaRequestTimeoutInMillis = 300000;
    private ConnectionMode connectionMode = ConnectionMode.DIRECT;
    private int maxPoolSize = 1000;
    private int idleConnectionTimeoutInMillis = 60000;
    private String userAgentSuffix = "";
    private RetryOptions retryOptions = new RetryOptions();
    private boolean enableEndpointDiscovery = true;
    private List<String> preferredLocations;
    private boolean usingMultipleWriteLocations;
    private InetSocketAddress inetSocketProxyAddress;
    private Boolean enableReadRequestsFallback = null;

    public static ConnectionPolicy getDefaultPolicy() {
        if (default_policy == null) {
            default_policy = new ConnectionPolicy();
        }
        return default_policy;
    }

    public int getRequestTimeoutInMillis() {
        return this.requestTimeoutInMillis;
    }

    public ConnectionPolicy setRequestTimeoutInMillis(int requestTimeoutInMillis) {
        this.requestTimeoutInMillis = requestTimeoutInMillis;
        return this;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public ConnectionPolicy setConnectionMode(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public ConnectionPolicy setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public int getIdleConnectionTimeoutInMillis() {
        return this.idleConnectionTimeoutInMillis;
    }

    public ConnectionPolicy setIdleConnectionTimeoutInMillis(int idleConnectionTimeoutInMillis) {
        this.idleConnectionTimeoutInMillis = idleConnectionTimeoutInMillis;
        return this;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public ConnectionPolicy setUserAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
        return this;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public ConnectionPolicy setRetryOptions(RetryOptions retryOptions) {
        if (retryOptions == null) {
            throw new IllegalArgumentException("retryOptions value must not be null.");
        }
        this.retryOptions = retryOptions;
        return this;
    }

    public boolean getEnableEndpointDiscovery() {
        return this.enableEndpointDiscovery;
    }

    public ConnectionPolicy setEnableEndpointDiscovery(boolean enableEndpointDiscovery) {
        this.enableEndpointDiscovery = enableEndpointDiscovery;
        return this;
    }

    public boolean getUsingMultipleWriteLocations() {
        return this.usingMultipleWriteLocations;
    }

    public Boolean getEnableReadRequestsFallback() {
        return this.enableReadRequestsFallback;
    }

    public ConnectionPolicy setUsingMultipleWriteLocations(boolean usingMultipleWriteLocations) {
        this.usingMultipleWriteLocations = usingMultipleWriteLocations;
        return this;
    }

    public ConnectionPolicy setEnableReadRequestsFallback(Boolean enableReadRequestsFallback) {
        this.enableReadRequestsFallback = enableReadRequestsFallback;
        return this;
    }

    public List<String> getPreferredLocations() {
        return this.preferredLocations != null ? this.preferredLocations : Collections.emptyList();
    }

    public ConnectionPolicy setPreferredLocations(List<String> preferredLocations) {
        this.preferredLocations = preferredLocations;
        return this;
    }

    public InetSocketAddress getProxy() {
        return this.inetSocketProxyAddress;
    }

    public ConnectionPolicy setProxy(String proxyHost, int proxyPort) {
        this.inetSocketProxyAddress = new InetSocketAddress(proxyHost, proxyPort);
        return this;
    }

    public String toString() {
        return "ConnectionPolicy{requestTimeoutInMillis=" + this.requestTimeoutInMillis + ", mediaRequestTimeoutInMillis=" + this.mediaRequestTimeoutInMillis + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", maxPoolSize=" + this.maxPoolSize + ", idleConnectionTimeoutInMillis=" + this.idleConnectionTimeoutInMillis + ", userAgentSuffix='" + this.userAgentSuffix + '\'' + ", retryOptions=" + this.retryOptions + ", enableEndpointDiscovery=" + this.enableEndpointDiscovery + ", preferredLocations=" + this.preferredLocations + ", usingMultipleWriteLocations=" + this.usingMultipleWriteLocations + ", inetSocketProxyAddress=" + this.inetSocketProxyAddress + '}';
    }
}

