/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;

public class ExponentialBackoffOptions {
    private static final ClientLogger LOGGER = new ClientLogger(ExponentialBackoffOptions.class);
    private Integer maxRetries;
    private Duration baseDelay;
    private Duration maxDelay;

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public ExponentialBackoffOptions setMaxRetries(Integer maxRetries) {
        if (maxRetries != null && maxRetries < 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Max retries cannot be less than 0."));
        }
        this.maxRetries = maxRetries;
        return this;
    }

    public Duration getBaseDelay() {
        return this.baseDelay;
    }

    public ExponentialBackoffOptions setBaseDelay(Duration baseDelay) {
        this.validateDelays(baseDelay, this.maxDelay);
        this.baseDelay = baseDelay;
        return this;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public ExponentialBackoffOptions setMaxDelay(Duration maxDelay) {
        this.validateDelays(this.baseDelay, maxDelay);
        this.maxDelay = maxDelay;
        return this;
    }

    private void validateDelays(Duration baseDelay, Duration maxDelay) {
        if (baseDelay != null && (baseDelay.isZero() || baseDelay.isNegative())) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'baseDelay' cannot be negative or 0."));
        }
        if (maxDelay != null && (maxDelay.isZero() || maxDelay.isNegative())) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'maxDelay' cannot be negative or 0."));
        }
        if (baseDelay != null && maxDelay != null && baseDelay.compareTo(maxDelay) > 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'baseDelay' cannot be greater than 'maxDelay'."));
        }
    }
}

