/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.logging.ClientLogger;
import java.util.Map;
import java.util.TreeMap;

public enum SerializerEncoding {
    JSON,
    XML;

    private static final ClientLogger LOGGER;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final Map<String, SerializerEncoding> SUPPORTED_MIME_TYPES;
    private static final TreeMap<String, SerializerEncoding> SUPPORTED_SUFFIXES;
    private static final SerializerEncoding DEFAULT_ENCODING;

    public static SerializerEncoding fromHeaders(HttpHeaders headers) {
        String mimeContentType = headers.getValue(CONTENT_TYPE);
        if (mimeContentType == null || mimeContentType.isEmpty()) {
            LOGGER.warning("'{}' not found. Returning default encoding: {}", new Object[]{CONTENT_TYPE, DEFAULT_ENCODING});
            return DEFAULT_ENCODING;
        }
        String[] parts = mimeContentType.split(";");
        SerializerEncoding encoding = SUPPORTED_MIME_TYPES.get(parts[0]);
        if (encoding != null) {
            return encoding;
        }
        String[] mimeTypeParts = parts[0].split("/");
        if (mimeTypeParts.length != 2) {
            LOGGER.warning("Content-Type '{}' does not match mime-type formatting 'type'/'subtype'. Returning default: {}", new Object[]{parts[0], DEFAULT_ENCODING});
            return DEFAULT_ENCODING;
        }
        String subtype = mimeTypeParts[1];
        int lastIndex = subtype.lastIndexOf("+");
        if (lastIndex == -1) {
            return DEFAULT_ENCODING;
        }
        String mimeTypeSuffix = subtype.substring(lastIndex + 1);
        SerializerEncoding serializerEncoding = SUPPORTED_SUFFIXES.get(mimeTypeSuffix);
        if (serializerEncoding != null) {
            return serializerEncoding;
        }
        LOGGER.warning("Content-Type '{}' does not match any supported one. Returning default: {}", new Object[]{mimeContentType, DEFAULT_ENCODING});
        return DEFAULT_ENCODING;
    }

    static {
        LOGGER = new ClientLogger(SerializerEncoding.class);
        DEFAULT_ENCODING = JSON;
        SUPPORTED_MIME_TYPES = new TreeMap<String, SerializerEncoding>(String.CASE_INSENSITIVE_ORDER);
        SUPPORTED_MIME_TYPES.put("text/xml", XML);
        SUPPORTED_MIME_TYPES.put("application/xml", XML);
        SUPPORTED_MIME_TYPES.put("application/json", JSON);
        SUPPORTED_SUFFIXES = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        SUPPORTED_SUFFIXES.put("xml", XML);
        SUPPORTED_SUFFIXES.put("json", JSON);
    }
}

