/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.Configuration;
import com.azure.core.util.ConfigurationProperty;
import com.azure.core.util.ConfigurationPropertyBuilder;

public class MetricsOptions {
    private static final ConfigurationProperty<Boolean> IS_DISABLED_PROPERTY = ConfigurationPropertyBuilder.ofBoolean("metrics.disabled").environmentVariableName("AZURE_METRICS_DISABLED").shared(true).defaultValue(false).build();
    private boolean isEnabled = Configuration.getGlobalConfiguration().get(IS_DISABLED_PROPERTY) == false;

    public static MetricsOptions fromConfiguration(Configuration configuration) {
        if (configuration.contains(IS_DISABLED_PROPERTY)) {
            return new MetricsOptions().setEnabled(configuration.get(IS_DISABLED_PROPERTY) == false);
        }
        return new MetricsOptions();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public MetricsOptions setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        return this;
    }
}

