/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.SemanticVersion;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.databind.cfg.PackageVersion;

final class JacksonVersion {
    private final SemanticVersion coreVersion = SemanticVersion.parse(new com.fasterxml.jackson.core.json.PackageVersion().version().toString());
    private final SemanticVersion databindVersion = SemanticVersion.parse(new PackageVersion().version().toString());
    private final SemanticVersion xmlVersion = SemanticVersion.parse(new com.fasterxml.jackson.dataformat.xml.PackageVersion().version().toString());
    private final SemanticVersion jsr310Version = SemanticVersion.parse(new com.fasterxml.jackson.datatype.jsr310.PackageVersion().version().toString());
    private static final String CORE_PACKAGE_NAME = "jackson-core";
    private static final String DATABIND_PACKAGE_NAME = "jackson-databind";
    private static final String XML_PACKAGE_NAME = "jackson-dataformat-xml";
    private static final String JSR310_PACKAGE_NAME = "jackson-datatype-jsr310";
    private static final String TROUBLESHOOTING_DOCS_LINK = "https://aka.ms/azsdk/java/dependency/troubleshoot";
    private static final SemanticVersion MIN_SUPPORTED_VERSION = SemanticVersion.parse("2.10.0");
    private static final int MAX_SUPPORTED_MAJOR_VERSION = 2;
    private static final String AZURE_CORE_PROPERTIES_NAME = "azure-core.properties";
    private static final String AZURE_CORE_PROPERTIES_VERSION_KEY = "version";
    private static final String AZURE_CORE_VERSION = CoreUtils.getProperties("azure-core.properties").getOrDefault("version", "unknown");
    private static final ClientLogger LOGGER = new ClientLogger(JacksonVersion.class);
    private static JacksonVersion instance = null;
    private final String helpString;

    private JacksonVersion() {
        this.checkVersion(this.coreVersion, CORE_PACKAGE_NAME);
        this.checkVersion(this.databindVersion, DATABIND_PACKAGE_NAME);
        this.checkVersion(this.xmlVersion, XML_PACKAGE_NAME);
        this.checkVersion(this.jsr310Version, JSR310_PACKAGE_NAME);
        this.helpString = this.formatHelpString();
        LOGGER.info(this.helpString);
    }

    public String getHelpInfo() {
        return this.helpString;
    }

    public static synchronized JacksonVersion getInstance() {
        if (instance == null) {
            instance = new JacksonVersion();
        }
        return instance;
    }

    private void checkVersion(SemanticVersion version, String packageName) {
        if (!version.isValid()) {
            LOGGER.verbose("Could not find version of '{}'.", packageName);
            return;
        }
        if (version.compareTo(MIN_SUPPORTED_VERSION) < 0) {
            LOGGER.warning("Version '{}' of package '{}' is not supported (older than earliest supported version - `{}`). It may result in runtime exceptions during serialization. Please consider updating Jackson to one of the supported versions {}", version.getVersionString(), packageName, MIN_SUPPORTED_VERSION, TROUBLESHOOTING_DOCS_LINK);
        }
        if (version.getMajorVersion() > 2) {
            LOGGER.warning("Major version '{}' of package '{}' is newer than latest supported version - '{}'. It may result in runtime exceptions during serialization.", version.getVersionString(), packageName, 2);
        }
    }

    private String formatHelpString() {
        return "Package versions: jackson-core=" + this.coreVersion.getVersionString() + ", " + DATABIND_PACKAGE_NAME + "=" + this.databindVersion.getVersionString() + ", " + XML_PACKAGE_NAME + "=" + this.xmlVersion.getVersionString() + ", " + JSR310_PACKAGE_NAME + "=" + this.jsr310Version.getVersionString() + ", azure-core=" + AZURE_CORE_VERSION + ", Troubleshooting version conflicts: " + TROUBLESHOOTING_DOCS_LINK;
    }
}

