/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.implementation.http.rest.AsyncRestProxy;
import com.azure.core.implementation.http.rest.RestProxyUtils;
import com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import com.azure.core.implementation.http.rest.SwaggerMethodParser;
import com.azure.core.implementation.http.rest.SyncRestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import reactor.core.publisher.Mono;

public final class RestProxy
implements InvocationHandler {
    private final SwaggerInterfaceParser interfaceParser;
    private final AsyncRestProxy asyncRestProxy;
    private final HttpPipeline httpPipeline;
    private final SyncRestProxy syncRestProxy;
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";

    private RestProxy(HttpPipeline httpPipeline, SerializerAdapter serializer, SwaggerInterfaceParser interfaceParser) {
        this.interfaceParser = interfaceParser;
        this.asyncRestProxy = new AsyncRestProxy(httpPipeline, serializer, interfaceParser);
        this.syncRestProxy = new SyncRestProxy(httpPipeline, serializer, interfaceParser);
        this.httpPipeline = httpPipeline;
    }

    private SwaggerMethodParser getMethodParser(Method method) {
        return this.interfaceParser.getMethodParser(method);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context contextData) {
        return this.httpPipeline.send(request, contextData);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        RestProxyUtils.validateResumeOperationIsNotPresent(method);
        SwaggerMethodParser methodParser = this.getMethodParser(method);
        RequestOptions options = methodParser.setRequestOptions(args);
        Context context = methodParser.setContext(args);
        boolean isReactive = methodParser.isReactive();
        boolean isStreamResponseType = methodParser.isStreamResponse();
        boolean syncRestProxyEnabled = (Boolean)context.getData(HTTP_REST_PROXY_SYNC_PROXY_ENABLE).orElse(false);
        if (isReactive || isStreamResponseType || !syncRestProxyEnabled) {
            return this.asyncRestProxy.invoke(proxy, method, options, options != null ? options.getErrorOptions() : null, options != null ? options.getRequestCallback() : null, methodParser, isReactive, args);
        }
        return this.syncRestProxy.invoke(proxy, method, options, options != null ? options.getErrorOptions() : null, options != null ? options.getRequestCallback() : null, methodParser, isReactive, args);
    }

    public static <A> A create(Class<A> swaggerInterface) {
        return RestProxy.create(swaggerInterface, RestProxyUtils.createDefaultPipeline(), RestProxyUtils.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline) {
        return RestProxy.create(swaggerInterface, httpPipeline, RestProxyUtils.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline, SerializerAdapter serializer) {
        SwaggerInterfaceParser interfaceParser = new SwaggerInterfaceParser(swaggerInterface, serializer);
        RestProxy restProxy = new RestProxy(httpPipeline, serializer, interfaceParser);
        return (A)Proxy.newProxyInstance(swaggerInterface.getClassLoader(), new Class[]{swaggerInterface}, (InvocationHandler)restProxy);
    }
}

