/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JacksonAdapterTests {
    @Test
    public void emptyMap() throws IOException {
        HashMap map = new HashMap();
        JacksonAdapter serializer = new JacksonAdapter();
        Assertions.assertEquals((Object)"{}", (Object)serializer.serialize(map, SerializerEncoding.JSON));
    }

    @Test
    public void mapWithNullKey() throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(null, null);
        JacksonAdapter serializer = new JacksonAdapter();
        Assertions.assertEquals((Object)"{}", (Object)serializer.serialize(map, SerializerEncoding.JSON));
    }

    @Test
    public void mapWithEmptyKeyAndNullValue() throws IOException {
        MapHolder mapHolder = new MapHolder();
        mapHolder.map(new HashMap<String, String>());
        mapHolder.map().put("", null);
        JacksonAdapter serializer = new JacksonAdapter();
        Assertions.assertEquals((Object)"{\"map\":{\"\":null}}", (Object)serializer.serialize((Object)mapHolder, SerializerEncoding.JSON));
    }

    @Test
    public void mapWithEmptyKeyAndEmptyValue() throws IOException {
        MapHolder mapHolder = new MapHolder();
        mapHolder.map = new HashMap<String, String>();
        mapHolder.map.put("", "");
        JacksonAdapter serializer = new JacksonAdapter();
        Assertions.assertEquals((Object)"{\"map\":{\"\":\"\"}}", (Object)serializer.serialize((Object)mapHolder, SerializerEncoding.JSON));
    }

    @Test
    public void mapWithEmptyKeyAndNonEmptyValue() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("", "test");
        JacksonAdapter serializer = new JacksonAdapter();
        Assertions.assertEquals((Object)"{\"\":\"test\"}", (Object)serializer.serialize(map, SerializerEncoding.JSON));
    }

    @ParameterizedTest
    @MethodSource(value={"xmlBomRemovalSupplier"})
    public void xmlBomRemoval(String xml, String expected) throws IOException {
        XmlString actual = (XmlString)new JacksonAdapter().deserialize(xml, XmlString.class, SerializerEncoding.XML);
        if (expected == null) {
            Assertions.assertNull((Object)actual);
        } else {
            Assertions.assertEquals((Object)expected, (Object)actual.getValue());
        }
    }

    private static Stream<Arguments> xmlBomRemovalSupplier() {
        byte[] utf8BomBytes = new byte[]{-17, -69, -65};
        String utf8Bom = new String(utf8BomBytes, StandardCharsets.UTF_8);
        String cp1252Utf8Bom = new String(utf8BomBytes);
        String cleanXml = "\ufeff<?xml version=\"1.0\" encoding=\"utf-8\"?><XmlString><Value>This is clean xml.</Value></XmlString>";
        String dirtyXml = "\ufeff<?xml version=\"1.0\" encoding=\"utf-8\"?><XmlString><Value>Clean this xml.</Value></XmlString>";
        return Stream.of(Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{"", null}), Arguments.of((Object[])new Object[]{utf8Bom, null}), Arguments.of((Object[])new Object[]{cp1252Utf8Bom, null}), Arguments.of((Object[])new Object[]{cleanXml, "This is clean xml."}), Arguments.of((Object[])new Object[]{utf8Bom.concat(dirtyXml), "Clean this xml."}), Arguments.of((Object[])new Object[]{cp1252Utf8Bom.concat(dirtyXml), "Clean this xml."}));
    }

    @JacksonXmlRootElement(localName="XmlString")
    private static class XmlString {
        @JsonProperty(value="Value")
        private String value;

        private XmlString() {
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class MapHolder {
        @JsonInclude(content=JsonInclude.Include.ALWAYS)
        private Map<String, String> map = new HashMap<String, String>();

        private MapHolder() {
        }

        public Map<String, String> map() {
            return this.map;
        }

        public void map(Map<String, String> map) {
            this.map = map;
        }
    }
}

