/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.serializer.Foo;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlatteningSerializerTests {
    @Test
    public void canFlatten() throws Exception {
        Foo foo = new Foo();
        foo.bar("hello.world");
        foo.baz(new ArrayList<String>());
        foo.baz().add("hello");
        foo.baz().add("hello.world");
        foo.qux(new HashMap<String, String>());
        foo.qux().put("hello", "world");
        foo.qux().put("a.b", "c.d");
        foo.qux().put("bar.a", "ttyy");
        foo.qux().put("bar.b", "uuzz");
        foo.moreProps("hello");
        JacksonAdapter adapter = new JacksonAdapter();
        String serialized = adapter.serialize((Object)foo, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"$type\":\"foo\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}},\"more.props\":\"hello\"}}", (Object)serialized);
        Foo deserialized = (Foo)adapter.deserialize(serialized, Foo.class, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"hello.world", (Object)deserialized.bar());
        Assertions.assertArrayEquals((Object[])new String[]{"hello", "hello.world"}, (Object[])deserialized.baz().toArray());
        Assertions.assertNotNull(deserialized.qux());
        Assertions.assertEquals((Object)"world", (Object)deserialized.qux().get("hello"));
        Assertions.assertEquals((Object)"c.d", (Object)deserialized.qux().get("a.b"));
        Assertions.assertEquals((Object)"ttyy", (Object)deserialized.qux().get("bar.a"));
        Assertions.assertEquals((Object)"uuzz", (Object)deserialized.qux().get("bar.b"));
        Assertions.assertEquals((Object)"hello", (Object)deserialized.moreProps());
    }

    @Test
    public void canSerializeMapKeysWithDotAndSlash() throws Exception {
        String serialized = new JacksonAdapter().serialize((Object)this.prepareSchoolModel(), SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"teacher\":{\"students\":{\"af.B/D\":{},\"af.B/C\":{}}},\"tags\":{\"foo.aa\":\"bar\",\"x.y\":\"zz\"},\"properties\":{\"name\":\"school1\"}}", (Object)serialized);
    }

    private School prepareSchoolModel() {
        Teacher teacher = new Teacher();
        HashMap<String, Student> students = new HashMap<String, Student>();
        students.put("af.B/C", new Student());
        students.put("af.B/D", new Student());
        teacher.withStudents(students);
        School school = new School().withName("school1");
        school.withTeacher(teacher);
        HashMap<String, String> schoolTags = new HashMap<String, String>();
        schoolTags.put("foo.aa", "bar");
        schoolTags.put("x.y", "zz");
        school.withTags(schoolTags);
        return school;
    }

    private class Teacher {
        @JsonProperty(value="students")
        private Map<String, Student> students;

        private Teacher() {
        }

        public Teacher withStudents(Map<String, Student> students) {
            this.students = students;
            return this;
        }
    }

    private class Student {
        private Student() {
        }
    }

    @JsonFlatten
    private class School {
        @JsonProperty(value="teacher")
        private Teacher teacher;
        @JsonProperty(value="properties.name")
        private String name;
        @JsonProperty(value="tags")
        private Map<String, String> tags;

        private School() {
        }

        public School withTeacher(Teacher teacher) {
            this.teacher = teacher;
            return this;
        }

        public School withName(String name) {
            this.name = name;
            return this;
        }

        public School withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }
    }
}

