/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.util.serializer.DateTimeSerializer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateTimeSerializerTests {
    @Test
    public void toStringWithNull() {
        Assertions.assertNull((Object)DateTimeSerializer.toString(null));
    }

    @Test
    public void toStringOffsetDateTime() {
        Assertions.assertEquals((Object)"0001-01-01T14:00:00Z", (Object)DateTimeSerializer.toString((OffsetDateTime)OffsetDateTime.of(1, 1, 1, 0, 0, 0, 0, ZoneOffset.ofHours(-14))));
        Assertions.assertEquals((Object)"10000-01-01T13:59:59.999Z", (Object)DateTimeSerializer.toString((OffsetDateTime)OffsetDateTime.of(LocalDate.of(10000, 1, 1), LocalTime.parse("13:59:59.999"), ZoneOffset.UTC)));
        Assertions.assertEquals((Object)"2010-01-01T12:34:56Z", (Object)DateTimeSerializer.toString((OffsetDateTime)OffsetDateTime.of(2010, 1, 1, 12, 34, 56, 0, ZoneOffset.UTC)));
        Assertions.assertEquals((Object)"0001-01-01T00:00:00Z", (Object)DateTimeSerializer.toString((OffsetDateTime)OffsetDateTime.of(1, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC)));
    }
}

