/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.DefaultSyncPoller;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class PollerTests {
    @Mock
    private Function<PollingContext<Response>, Mono<Response>> activationOperation;
    @Mock
    private Function<PollingContext<Response>, Mono<PollResponse<Response>>> activationOperationWithResponse;
    @Mock
    private Function<PollingContext<Response>, Mono<PollResponse<Response>>> pollOperation;
    @Mock
    private Function<PollingContext<Response>, Mono<CertificateOutput>> fetchResultOperation;
    @Mock
    private BiFunction<PollingContext<Response>, PollResponse<Response>, Mono<Response>> cancelOperation;

    @BeforeEach
    public void beforeTest() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @AfterEach
    public void afterTest() {
        Mockito.framework().clearInlineMocks();
    }

    @Test
    public void asyncPollerConstructorPollIntervalZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PollerFlux(Duration.ZERO, this.activationOperation, this.pollOperation, this.cancelOperation, this.fetchResultOperation));
    }

    @Test
    public void asyncPollerConstructorPollIntervalNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PollerFlux(Duration.ofSeconds(-1L), this.activationOperation, this.pollOperation, this.cancelOperation, this.fetchResultOperation));
    }

    @Test
    public void asyncPollerConstructorPollIntervalNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new PollerFlux(null, this.activationOperation, this.pollOperation, this.cancelOperation, this.fetchResultOperation));
    }

    @Test
    public void asyncPollerConstructorActivationOperationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new PollerFlux(Duration.ofSeconds(1L), null, this.pollOperation, this.cancelOperation, this.fetchResultOperation));
    }

    @Test
    public void asyncPollerConstructorPollOperationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new PollerFlux(Duration.ofSeconds(1L), this.activationOperation, null, this.cancelOperation, this.fetchResultOperation));
    }

    @Test
    public void asyncPollerConstructorCancelOperationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new PollerFlux(Duration.ofSeconds(1L), this.activationOperation, this.pollOperation, null, this.fetchResultOperation));
    }

    @Test
    public void asyncPollerConstructorFetchResultOperationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new PollerFlux(Duration.ofSeconds(1L), this.activationOperation, this.pollOperation, this.cancelOperation, null));
    }

    @Test
    public void subscribeToSpecificOtherOperationStatusTest() {
        Duration retryAfter = Duration.ofMillis(100L);
        PollResponse response0 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("0"), retryAfter);
        PollResponse response1 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("1"), retryAfter);
        PollResponse response2 = new PollResponse(LongRunningOperationStatus.fromString((String)"OTHER_1", (boolean)false), (Object)new Response("2"), retryAfter);
        PollResponse response3 = new PollResponse(LongRunningOperationStatus.fromString((String)"OTHER_2", (boolean)false), (Object)new Response("3"), retryAfter);
        PollResponse response4 = new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)new Response("4"), retryAfter);
        Mockito.when(this.activationOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.empty());
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.just((Object)response0), (Object[])new Mono[]{Mono.just((Object)response1), Mono.just((Object)response2), Mono.just((Object)response3), Mono.just((Object)response4)});
        PollerFlux pollerFlux = new PollerFlux(Duration.ofSeconds(1L), this.activationOperation, this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        StepVerifier.create((Publisher)pollerFlux).expectSubscription().expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response0.getStatus()).expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response1.getStatus()).expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response2.getStatus()).expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response3.getStatus()).expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response4.getStatus()).verifyComplete();
    }

    @Test
    public void noPollingForSynchronouslyCompletedActivationTest() {
        int[] activationCallCount = new int[]{0};
        Mockito.when(this.activationOperationWithResponse.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> {
            activationCallCount[0] = activationCallCount[0] + 1;
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)new Response("ActivationDone")));
        }));
        PollerFlux pollerFlux = PollerFlux.create((Duration)Duration.ofSeconds(1L), this.activationOperationWithResponse, this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.error((Throwable)new RuntimeException("Polling shouldn't happen for synchronously completed activation.")));
        StepVerifier.create((Publisher)pollerFlux).expectSubscription().expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED).verifyComplete();
        Assertions.assertEquals((int)1, (int)activationCallCount[0]);
    }

    @Test
    public void ensurePollingForInProgressActivationResponseTest() {
        Duration retryAfter = Duration.ofMillis(100L);
        int[] activationCallCount = new int[]{0};
        Mockito.when(this.activationOperationWithResponse.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> {
            activationCallCount[0] = activationCallCount[0] + 1;
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("ActivationDone")));
        }));
        PollerFlux pollerFlux = PollerFlux.create((Duration)Duration.ofSeconds(1L), this.activationOperationWithResponse, this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        PollResponse response0 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("0"), retryAfter);
        PollResponse response1 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("1"), retryAfter);
        PollResponse response2 = new PollResponse(LongRunningOperationStatus.fromString((String)"OTHER_1", (boolean)false), (Object)new Response("2"), retryAfter);
        PollResponse response3 = new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)new Response("3"), retryAfter);
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.just((Object)response0), (Object[])new Mono[]{Mono.just((Object)response1), Mono.just((Object)response2), Mono.just((Object)response3)});
        StepVerifier.create((Publisher)pollerFlux).expectSubscription().expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response0.getStatus()).expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response1.getStatus()).expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response2.getStatus()).expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response3.getStatus()).verifyComplete();
        Assertions.assertEquals((int)1, (int)activationCallCount[0]);
    }

    @Test
    public void subscribeToActivationOnlyOnceTest() {
        Duration retryAfter = Duration.ofMillis(100L);
        PollResponse response0 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("0"), retryAfter);
        PollResponse response1 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("1"), retryAfter);
        PollResponse response2 = new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)new Response("2"), retryAfter);
        int[] activationCallCount = new int[]{0};
        Mockito.when(this.activationOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> {
            activationCallCount[0] = activationCallCount[0] + 1;
            return Mono.just((Object)new Response("ActivationDone"));
        }));
        PollerFlux pollerFlux = new PollerFlux(Duration.ofSeconds(1L), this.activationOperation, this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.just((Object)response0), (Object[])new Mono[]{Mono.just((Object)response1), Mono.just((Object)response2)});
        StepVerifier.create((Publisher)pollerFlux).expectSubscription().expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response0.getStatus()).expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response1.getStatus()).expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response2.getStatus()).verifyComplete();
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.just((Object)response0), (Object[])new Mono[]{Mono.just((Object)response1), Mono.just((Object)response2)});
        StepVerifier.create((Publisher)pollerFlux).expectSubscription().expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response0.getStatus()).expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response1.getStatus()).expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == response2.getStatus()).verifyComplete();
        Assertions.assertEquals((int)1, (int)activationCallCount[0]);
    }

    @Test
    public void cancellationCanBeCalledFromOperatorChainTest() {
        Duration retryAfter = Duration.ofMillis(100L);
        PollResponse response0 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("0"), retryAfter);
        PollResponse response1 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("1"), retryAfter);
        PollResponse response2 = new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)new Response("2"), retryAfter);
        Response activationResponse = new Response("Foo");
        Mockito.when(this.activationOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> Mono.just((Object)activationResponse)));
        ArrayList cancelParameters = new ArrayList();
        Mockito.when(this.cancelOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()), (PollResponse<Response>)((PollResponse)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            for (Object argument : invocation.getArguments()) {
                cancelParameters.add(argument);
            }
            return Mono.just((Object)new Response("OperationCancelled"));
        });
        PollerFlux pollerFlux = new PollerFlux(Duration.ofSeconds(1L), this.activationOperation, this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.just((Object)response0), (Object[])new Mono[]{Mono.just((Object)response1), Mono.just((Object)response2)});
        AsyncPollResponse[] secondAsyncResponse = new AsyncPollResponse[]{null};
        Response cancelResponse = (Response)pollerFlux.take(2L).last().flatMap(asyncPollResponse -> {
            secondAsyncResponse[0] = asyncPollResponse;
            return asyncPollResponse.cancelOperation();
        }).block();
        Assertions.assertNotNull((Object)cancelResponse);
        Assertions.assertTrue((boolean)cancelResponse.getResponse().equalsIgnoreCase("OperationCancelled"));
        Assertions.assertNotNull((Object)secondAsyncResponse[0]);
        Assertions.assertTrue((boolean)((Response)secondAsyncResponse[0].getValue()).getResponse().equalsIgnoreCase("1"));
        Assertions.assertEquals((int)2, (int)cancelParameters.size());
        cancelParameters.get(0).equals(activationResponse);
        cancelParameters.get(1).equals(response1);
    }

    @Test
    public void getResultCanBeCalledFromOperatorChainTest() {
        Duration retryAfter = Duration.ofMillis(100L);
        PollResponse response0 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("0"), retryAfter);
        PollResponse response1 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("1"), retryAfter);
        PollResponse response2 = new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)new Response("2"), retryAfter);
        Response activationResponse = new Response("Foo");
        Mockito.when(this.activationOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> Mono.just((Object)activationResponse)));
        ArrayList fetchResultParameters = new ArrayList();
        Mockito.when(this.fetchResultOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            for (Object argument : invocation.getArguments()) {
                fetchResultParameters.add(argument);
            }
            return Mono.just((Object)new CertificateOutput("LROFinalResult"));
        });
        PollerFlux pollerFlux = new PollerFlux(Duration.ofSeconds(1L), this.activationOperation, this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.just((Object)response0), (Object[])new Mono[]{Mono.just((Object)response1), Mono.just((Object)response2)});
        AsyncPollResponse[] terminalAsyncResponse = new AsyncPollResponse[]{null};
        CertificateOutput lroResult = (CertificateOutput)pollerFlux.takeUntil(apr -> apr.getStatus().isComplete()).last().flatMap(asyncPollResponse -> {
            terminalAsyncResponse[0] = asyncPollResponse;
            return asyncPollResponse.getFinalResult();
        }).block();
        Assertions.assertNotNull((Object)lroResult);
        Assertions.assertTrue((boolean)lroResult.getName().equalsIgnoreCase("LROFinalResult"));
        Assertions.assertNotNull((Object)terminalAsyncResponse[0]);
        Assertions.assertTrue((boolean)((Response)terminalAsyncResponse[0].getValue()).getResponse().equalsIgnoreCase("2"));
        Assertions.assertEquals((int)1, (int)fetchResultParameters.size());
        Assertions.assertTrue((boolean)(fetchResultParameters.get(0) instanceof PollingContext));
        PollingContext pollingContext = (PollingContext)fetchResultParameters.get(0);
        pollingContext.getActivationResponse().equals(activationResponse);
        pollingContext.getLatestResponse().equals(response2);
    }

    @Test
    public void syncPollerConstructorPollIntervalZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DefaultSyncPoller(Duration.ZERO, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), this.pollOperation, this.cancelOperation, this.fetchResultOperation));
    }

    @Test
    public void syncPollerConstructorPollIntervalNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DefaultSyncPoller(Duration.ofSeconds(-1L), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), this.pollOperation, this.cancelOperation, this.fetchResultOperation));
    }

    @Test
    public void syncPollerConstructorPollIntervalNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new DefaultSyncPoller(null, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), this.pollOperation, this.cancelOperation, this.fetchResultOperation));
    }

    @Test
    public void syncConstructorActivationOperationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new DefaultSyncPoller(Duration.ofSeconds(1L), null, this.pollOperation, this.cancelOperation, this.fetchResultOperation));
    }

    @Test
    public void syncPollerConstructorPollOperationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new DefaultSyncPoller(Duration.ofSeconds(1L), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), null, this.cancelOperation, this.fetchResultOperation));
    }

    @Test
    public void syncPollerConstructorCancelOperationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new DefaultSyncPoller(Duration.ofSeconds(1L), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), this.pollOperation, null, this.fetchResultOperation));
    }

    @Test
    public void syncPollerConstructorFetchResultOperationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new DefaultSyncPoller(Duration.ofSeconds(1L), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), this.pollOperation, this.cancelOperation, null));
    }

    @Test
    public void syncPollerShouldCallActivationFromConstructor() {
        Boolean[] activationCalled = new Boolean[]{false};
        Mockito.when(this.activationOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> {
            activationCalled[0] = true;
            return Mono.just((Object)new Response("ActivationDone"));
        }));
        DefaultSyncPoller poller = new DefaultSyncPoller(Duration.ofSeconds(1L), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        Assertions.assertTrue((boolean)activationCalled[0]);
    }

    @Test
    public void eachPollShouldReceiveLastPollResponse() {
        Mockito.when(this.activationOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> Mono.just((Object)new Response("A"))));
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            Assertions.assertEquals((int)1, (int)invocation.getArguments().length);
            Assertions.assertTrue((boolean)(invocation.getArguments()[0] instanceof PollingContext));
            PollingContext pollingContext = (PollingContext)invocation.getArguments()[0];
            Assertions.assertTrue((boolean)(pollingContext.getActivationResponse() instanceof PollResponse));
            Assertions.assertTrue((boolean)(pollingContext.getLatestResponse() instanceof PollResponse));
            PollResponse latestResponse = pollingContext.getLatestResponse();
            Assertions.assertNotNull((Object)latestResponse);
            PollResponse nextResponse = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response(((Response)latestResponse.getValue()).toString() + "A"), Duration.ofMillis(100L));
            return Mono.just((Object)nextResponse);
        });
        DefaultSyncPoller poller = new DefaultSyncPoller(Duration.ofSeconds(1L), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        PollResponse pollResponse = poller.poll();
        Assertions.assertNotNull((Object)pollResponse);
        Assertions.assertNotNull((Object)((Response)pollResponse.getValue()).getResponse());
        Assertions.assertTrue((boolean)((Response)pollResponse.getValue()).getResponse().equalsIgnoreCase("Response: AA"));
        pollResponse = poller.poll();
        Assertions.assertNotNull((Object)pollResponse);
        Assertions.assertNotNull((Object)((Response)pollResponse.getValue()).getResponse());
        Assertions.assertTrue((boolean)((Response)pollResponse.getValue()).getResponse().equalsIgnoreCase("Response: Response: AAA"));
        pollResponse = poller.poll();
        Assertions.assertNotNull((Object)pollResponse);
        Assertions.assertNotNull((Object)((Response)pollResponse.getValue()).getResponse());
        Assertions.assertTrue((boolean)((Response)pollResponse.getValue()).getResponse().equalsIgnoreCase("Response: Response: Response: AAAA"));
    }

    @Test
    public void waitForCompletionShouldReturnTerminalPollResponse() {
        PollResponse response0 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("0"), Duration.ofMillis(100L));
        PollResponse response1 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("1"), Duration.ofMillis(100L));
        PollResponse response2 = new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)new Response("2"), Duration.ofMillis(100L));
        Response activationResponse = new Response("Activated");
        Mockito.when(this.activationOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> Mono.just((Object)activationResponse)));
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.just((Object)response0), (Object[])new Mono[]{Mono.just((Object)response1), Mono.just((Object)response2)});
        DefaultSyncPoller poller = new DefaultSyncPoller(Duration.ofSeconds(1L), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        PollResponse pollResponse = poller.waitForCompletion();
        Assertions.assertNotNull((Object)pollResponse.getValue());
        Assertions.assertEquals((Object)((Response)response2.getValue()).getResponse(), (Object)((Response)pollResponse.getValue()).getResponse());
        Assertions.assertEquals((Object)LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)pollResponse.getStatus());
    }

    @Test
    public void getResultShouldPollUntilCompletionAndFetchResult() {
        Response activationResponse = new Response("Activated");
        Mockito.when(this.activationOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> Mono.just((Object)activationResponse)));
        int[] invocationCount = new int[]{-1};
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenAnswer(invocationOnMock -> {
            invocationCount[0] = invocationCount[0] + 1;
            switch (invocationCount[0]) {
                case 0: {
                    return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("0"), Duration.ofMillis(100L)));
                }
                case 1: {
                    return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("1"), Duration.ofMillis(100L)));
                }
                case 2: {
                    return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)new Response("2"), Duration.ofMillis(100L)));
                }
            }
            throw new RuntimeException("Poll should not be called after terminal response");
        });
        Mockito.when(this.fetchResultOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> Mono.just((Object)new CertificateOutput("cert1"))));
        DefaultSyncPoller poller = new DefaultSyncPoller(Duration.ofSeconds(1L), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        CertificateOutput certificateOutput = (CertificateOutput)poller.getFinalResult();
        Assertions.assertNotNull((Object)certificateOutput);
        Assertions.assertEquals((Object)"cert1", (Object)certificateOutput.getName());
        Assertions.assertEquals((int)2, (int)invocationCount[0]);
    }

    @Test
    public void getResultShouldNotPollOnCompletedPoller() {
        PollResponse response0 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("0"), Duration.ofMillis(100L));
        PollResponse response1 = new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("1"), Duration.ofMillis(100L));
        PollResponse response2 = new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)new Response("2"), Duration.ofMillis(100L));
        Response activationResponse = new Response("Activated");
        Mockito.when(this.activationOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> Mono.just((Object)activationResponse)));
        Mockito.when(this.fetchResultOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> Mono.just((Object)new CertificateOutput("cert1"))));
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.just((Object)response0), (Object[])new Mono[]{Mono.just((Object)response1), Mono.just((Object)response2)});
        DefaultSyncPoller poller = new DefaultSyncPoller(Duration.ofSeconds(1L), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        PollResponse pollResponse = poller.waitForCompletion();
        Assertions.assertNotNull((Object)pollResponse.getValue());
        Assertions.assertEquals((Object)((Response)response2.getValue()).getResponse(), (Object)((Response)pollResponse.getValue()).getResponse());
        Assertions.assertEquals((Object)LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)pollResponse.getStatus());
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenAnswer(invocationOnMock -> {
            Assertions.assertTrue((boolean)true, (String)"A Poll after completion should be called");
            return Mono.empty();
        });
        CertificateOutput certificateOutput = (CertificateOutput)poller.getFinalResult();
        Assertions.assertNotNull((Object)certificateOutput);
        Assertions.assertEquals((Object)"cert1", (Object)certificateOutput.getName());
    }

    @Test
    public void waitUntilShouldPollAfterMatchingStatus() {
        Response activationResponse = new Response("Activated");
        Mockito.when(this.activationOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenReturn((Object)Mono.defer(() -> Mono.just((Object)activationResponse)));
        LongRunningOperationStatus matchStatus = LongRunningOperationStatus.fromString((String)"OTHER_1", (boolean)false);
        int[] invocationCount = new int[]{-1};
        Mockito.when(this.pollOperation.apply((PollingContext<Response>)((PollingContext)ArgumentMatchers.any()))).thenAnswer(invocationOnMock -> {
            invocationCount[0] = invocationCount[0] + 1;
            switch (invocationCount[0]) {
                case 0: {
                    return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("0"), Duration.ofMillis(100L)));
                }
                case 1: {
                    return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new Response("1"), Duration.ofMillis(100L)));
                }
                case 2: {
                    return Mono.just((Object)new PollResponse(matchStatus, (Object)new Response("1"), Duration.ofMillis(100L)));
                }
            }
            throw new RuntimeException("Poll should not be called after matching response");
        });
        DefaultSyncPoller poller = new DefaultSyncPoller(Duration.ofSeconds(1L), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)((Response)this.activationOperation.apply((PollingContext<Response>)cxt).block())), this.pollOperation, this.cancelOperation, this.fetchResultOperation);
        PollResponse pollResponse = poller.waitUntil(matchStatus);
        Assertions.assertEquals((Object)matchStatus, (Object)pollResponse.getStatus());
        Assertions.assertEquals((int)2, (int)invocationCount[0]);
    }

    public class CertificateOutput {
        String name;

        public CertificateOutput(String certName) {
            this.name = certName;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Response {
        private final String response;

        public Response(String response) {
            this.response = response;
        }

        public String getResponse() {
            return this.response;
        }

        public String toString() {
            return "Response: " + this.response;
        }
    }
}

