/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.logging;

import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;

public class ClientLoggerTests {
    private static final String PARAMETERIZED_TEST_NAME_TEMPLATE = "[{index}] {displayName}";
    private PrintStream originalSystemOut;
    private ByteArrayOutputStream logCaptureStream;

    @BeforeEach
    public void setupLoggingConfiguration() {
        System.setProperty("org.slf4j.simpleLogger.log.com.azure.core.util.logging.ClientLoggerTests", "trace");
        this.originalSystemOut = System.out;
        this.logCaptureStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.logCaptureStream));
    }

    @AfterEach
    public void revertLoggingConfiguration() throws Exception {
        System.clearProperty("org.slf4j.simpleLogger.log.com.azure.core.util.logging.ClientLoggerTests");
        System.setOut(this.originalSystemOut);
        this.logCaptureStream.close();
    }

    private void setPropertyToOriginalOrClear(String propertyName, String originalValue) {
        if (CoreUtils.isNullOrEmpty((CharSequence)originalValue)) {
            System.clearProperty(propertyName);
        } else {
            System.setProperty(propertyName, originalValue);
        }
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @ValueSource(ints={1, 2, 3, 4})
    public void logAtSupportedLevel(int logLevel) {
        String logMessage = "This is a test";
        String originalLogLevel = this.setupLogLevel(logLevel);
        this.logMessage(new ClientLogger(ClientLoggerTests.class), logLevel, logMessage, new Object[0]);
        this.setPropertyToOriginalOrClear("AZURE_LOG_LEVEL", originalLogLevel);
        String logValues = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)logValues.contains(logMessage));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @ValueSource(ints={1, 2, 3})
    public void logAtUnsupportedLevel(int logLevel) {
        String logMessage = "This is a test";
        String originalLogLevel = this.setupLogLevel(logLevel + 1);
        this.logMessage(new ClientLogger(ClientLoggerTests.class), logLevel, logMessage, new Object[0]);
        this.setPropertyToOriginalOrClear("AZURE_LOG_LEVEL", originalLogLevel);
        String logValues = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertFalse((boolean)logValues.contains(logMessage));
    }

    @Test
    public void logWhenLoggingNotSet() {
        Assertions.assertEquals((Object)LogLevel.NOT_SET, (Object)LogLevel.fromString(null));
    }

    @Test
    public void onlyLogExceptionMessage() {
        String logMessage = "This is an exception";
        String exceptionMessage = "An exception message";
        RuntimeException runtimeException = this.createRuntimeException(exceptionMessage);
        String originalLogLevel = this.setupLogLevel(2);
        this.logMessage(new ClientLogger(ClientLoggerTests.class), 3, logMessage, runtimeException);
        this.setPropertyToOriginalOrClear("AZURE_LOG_LEVEL", originalLogLevel);
        String logValues = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)logValues.contains(logMessage + System.lineSeparator() + runtimeException.getMessage()));
        Assertions.assertFalse((boolean)logValues.contains(runtimeException.getStackTrace()[0].toString()));
    }

    @Test
    public void logExceptionStackTrace() {
        String logMessage = "This is an exception fdsafdafdomcklamfd fdsafdafmlkdfmalsf fdsafdcacdalmd";
        String exceptionMessage = "An exception message";
        RuntimeException runtimeException = this.createRuntimeException(exceptionMessage);
        String originalLogLevel = this.setupLogLevel(1);
        this.logMessage(new ClientLogger(ClientLoggerTests.class), 3, logMessage, runtimeException);
        this.setPropertyToOriginalOrClear("AZURE_LOG_LEVEL", originalLogLevel);
        String logValues = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)logValues.contains(logMessage + System.lineSeparator() + runtimeException.getMessage()));
        Assertions.assertTrue((boolean)logValues.contains(runtimeException.getStackTrace()[0].toString()));
    }

    @Test
    public void logExceptionStackTraceWithErrorLevel() {
        String logMessage = "This is an exception";
        String exceptionMessage = "An exception message";
        RuntimeException runtimeException = this.createRuntimeException(exceptionMessage);
        String originalLogLevel = this.setupLogLevel(1);
        this.logMessage(new ClientLogger(ClientLoggerTests.class), 4, logMessage, runtimeException);
        this.setPropertyToOriginalOrClear("AZURE_LOG_LEVEL", originalLogLevel);
        String logValues = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)logValues.contains(logMessage + System.lineSeparator() + runtimeException.getMessage()));
        Assertions.assertTrue((boolean)logValues.contains(runtimeException.getStackTrace()[0].toString()));
    }

    @Test
    public void logExceptionStackTraceWithNoLogLevel() {
        String logMessage = "This is an exception";
        String exceptionMessage = "An exception message";
        RuntimeException runtimeException = this.createRuntimeException(exceptionMessage);
        String originalLogLevel = this.setupLogLevel(1);
        this.logMessage(new ClientLogger(ClientLoggerTests.class), 5, logMessage, runtimeException);
        this.setPropertyToOriginalOrClear("AZURE_LOG_LEVEL", originalLogLevel);
        String logValues = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)logValues.isEmpty());
    }

    @Test
    public void logExceptionWithInvalidLogLevel() {
        String logMessage = "This is an exception";
        Object runtimeException = new Object();
        String originalLogLevel = this.setupLogLevel(1);
        this.logMessage(new ClientLogger(ClientLoggerTests.class), 3, logMessage, runtimeException);
        this.setPropertyToOriginalOrClear("AZURE_LOG_LEVEL", originalLogLevel);
        String logValues = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)logValues.contains(logMessage));
    }

    @Test
    public void logExceptionAsWarningOnlyExceptionMessage() {
        String exceptionMessage = "An exception message";
        RuntimeException runtimeException = this.createRuntimeException(exceptionMessage);
        String originalLogLevel = this.setupLogLevel(2);
        new ClientLogger(ClientLoggerTests.class).logExceptionAsWarning(runtimeException);
        this.setPropertyToOriginalOrClear("AZURE_LOG_LEVEL", originalLogLevel);
        String logValues = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)logValues.contains(exceptionMessage + System.lineSeparator()));
        Assertions.assertFalse((boolean)logValues.contains(runtimeException.getStackTrace()[0].toString()));
    }

    @Test
    public void logExceptionAsWarningStackTrace() {
        String exceptionMessage = "An exception message";
        RuntimeException runtimeException = this.createRuntimeException(exceptionMessage);
        String originalLogLevel = this.setupLogLevel(1);
        new ClientLogger(ClientLoggerTests.class).logExceptionAsWarning(runtimeException);
        this.setPropertyToOriginalOrClear("AZURE_LOG_LEVEL", originalLogLevel);
        String logValues = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)logValues.contains(exceptionMessage + System.lineSeparator()));
        Assertions.assertTrue((boolean)logValues.contains(runtimeException.getStackTrace()[0].toString()));
    }

    @Test
    public void logExceptionAsErrorOnlyExceptionMessage() {
        String exceptionMessage = "An exception message";
        RuntimeException runtimeException = this.createRuntimeException(exceptionMessage);
        String originalLogLevel = this.setupLogLevel(2);
        new ClientLogger(ClientLoggerTests.class).logExceptionAsError(runtimeException);
        this.setPropertyToOriginalOrClear("AZURE_LOG_LEVEL", originalLogLevel);
        String logValues = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)logValues.contains(exceptionMessage + System.lineSeparator()));
        Assertions.assertFalse((boolean)logValues.contains(runtimeException.getStackTrace()[0].toString()));
    }

    @Test
    public void logExceptionAsErrorStackTrace() {
        String exceptionMessage = "An exception message";
        RuntimeException runtimeException = this.createRuntimeException(exceptionMessage);
        String originalLogLevel = this.setupLogLevel(1);
        new ClientLogger(ClientLoggerTests.class).logExceptionAsError(runtimeException);
        this.setPropertyToOriginalOrClear("AZURE_LOG_LEVEL", originalLogLevel);
        String logValues = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)logValues.contains(exceptionMessage + System.lineSeparator()));
        Assertions.assertTrue((boolean)logValues.contains(runtimeException.getStackTrace()[0].toString()));
    }

    @ParameterizedTest(name="{index} from logLevelToConfigure = {0}, logLevelToValidate = {1}, expected = {2}")
    @CsvSource(value={"1, 1, true", "1, 2, true", "1, 3, true", "1, 4, true", "2, 1, false", "1, VERBOSE, true", "1, info, true", "1, warning, true", "1, error, true", "2, verbose, false"})
    public void canLogAtLevel(int logLevelToConfigure, String logLevelToValidate, boolean expected) {
        this.setupLogLevel(logLevelToConfigure);
        LogLevel logLevel = LogLevel.fromString((String)logLevelToValidate);
        Assertions.assertEquals((Object)new ClientLogger(ClientLoggerTests.class).canLogAtLevel(logLevel), (Object)expected);
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @ValueSource(strings={"5", "invalid"})
    public void canLogAtLevelInvalid(String logLevelToValidate) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogLevel.fromString((String)logLevelToValidate));
    }

    private String setupLogLevel(int logLevelToSet) {
        String originalLogLevel = Configuration.getGlobalConfiguration().get("AZURE_LOG_LEVEL");
        Configuration.getGlobalConfiguration().put("AZURE_LOG_LEVEL", String.valueOf(logLevelToSet));
        return originalLogLevel;
    }

    private void logMessage(ClientLogger logger, int logLevelToLog, String logFormat, Object ... arguments) {
        switch (logLevelToLog) {
            case 1: {
                logger.verbose(logFormat, arguments);
                break;
            }
            case 2: {
                logger.info(logFormat, arguments);
                break;
            }
            case 3: {
                logger.warning(logFormat, arguments);
                break;
            }
            case 4: {
                logger.error(logFormat, arguments);
                break;
            }
        }
    }

    private RuntimeException createRuntimeException(String message) {
        RuntimeException runtimeException = new RuntimeException(message);
        StackTraceElement[] stackTraceElements = new StackTraceElement[]{new StackTraceElement("ClientLoggerTests", "onlyLogExceptionMessage", "ClientLoggerTests", 117)};
        runtimeException.setStackTrace(stackTraceElements);
        return runtimeException;
    }
}

