/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.util.IterableStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import reactor.core.publisher.Flux;

public class IterableStreamJavaDocCodeSnippets {
    public void streamSnippet() throws MalformedURLException {
        HttpHeaders httpHeaders = new HttpHeaders().put("header1", "value1").put("header2", "value2");
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        String deserializedHeaders = "header1,value1,header2,value2";
        IterableStream myIterableStream = new IterableStream(Flux.just(this.createPagedResponse(httpRequest, httpHeaders, deserializedHeaders, 1, 3)));
        myIterableStream.stream().forEach(resp -> {
            if (resp.getStatusCode() == 200) {
                System.out.printf("Response headers are %s. Url %s%n", resp.getDeserializedHeaders(), resp.getRequest().getUrl());
                resp.getItems().forEach(value -> System.out.printf("Response value is %d%n", value));
            }
        });
    }

    public void iteratorwhileSnippet() throws MalformedURLException {
        HttpHeaders httpHeaders = new HttpHeaders().put("header1", "value1").put("header2", "value2");
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        String deserializedHeaders = "header1,value1,header2,value2";
        IterableStream myIterableStream = new IterableStream(Flux.just(this.createPagedResponse(httpRequest, httpHeaders, deserializedHeaders, 1, 3)));
        for (PagedResponseBase resp : myIterableStream) {
            if (resp.getStatusCode() != 200) continue;
            System.out.printf("Response headers are %s. Url %s%n", resp.getDeserializedHeaders(), resp.getRequest().getUrl());
            resp.getItems().forEach(value -> System.out.printf("Response value is %d%n", value));
        }
    }

    public void iteratorStreamFilterSnippet() throws MalformedURLException {
        HttpHeaders httpHeaders = new HttpHeaders().put("header1", "value1").put("header2", "value2");
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        String deserializedHeaders = "header1,value1,header2,value2";
        IterableStream myIterableStream = new IterableStream(Flux.just(this.createPagedResponse(httpRequest, httpHeaders, deserializedHeaders, 1, 3)));
        myIterableStream.stream().filter(resp -> resp.getStatusCode() == 200).limit(10L).forEach(resp -> {
            System.out.printf("Response headers are %s. Url %s%n", resp.getDeserializedHeaders(), resp.getRequest().getUrl());
            resp.getItems().forEach(value -> System.out.printf("Response value is %d%n", value));
        });
    }

    private PagedResponseBase<String, Integer> createPagedResponse(HttpRequest httpRequest, HttpHeaders httpHeaders, String deserializedHeaders, int i, int noOfPages) {
        return new PagedResponseBase(httpRequest, 200, httpHeaders, this.getItems(i), i < noOfPages - 1 ? String.valueOf(i + 1) : null, (Object)deserializedHeaders);
    }

    private List<Integer> getItems(Integer i) {
        return IntStream.range(i * 3, i * 3 + 3).boxed().collect(Collectors.toList());
    }
}

