/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class FluxUtilTest {
    @Test
    public void testCallWithContextGetSingle() {
        String response = (String)this.getSingle().subscriberContext(reactor.util.context.Context.of((Object)"FirstName", (Object)"Foo", (Object)"LastName", (Object)"Bar")).block();
        Assertions.assertEquals((Object)"Hello, Foo Bar", (Object)response);
    }

    @Test
    public void testCallWithContextGetCollection() {
        List<String> expectedLines = Arrays.asList("Hello,", "Foo", "Bar");
        ArrayList actualLines = new ArrayList();
        this.getCollection().subscriberContext(reactor.util.context.Context.of((Object)"FirstName", (Object)"Foo", (Object)"LastName", (Object)"Bar")).doOnNext(actualLines::add).subscribe();
        Assertions.assertEquals(expectedLines, actualLines);
    }

    @Test
    public void toReactorContextEmpty() {
        reactor.util.context.Context reactorContext = FluxUtil.toReactorContext(null);
        Assertions.assertTrue((boolean)reactorContext.isEmpty());
    }

    @Test
    public void toReactorContext() {
        Context context = new Context((Object)"key1", (Object)"value1");
        reactor.util.context.Context reactorContext = FluxUtil.toReactorContext((Context)context);
        Assertions.assertEquals((int)1, (int)reactorContext.size());
        Assertions.assertTrue((boolean)reactorContext.hasKey((Object)"key1"));
        Assertions.assertEquals((Object)"value1", (Object)reactorContext.get((Object)"key1"));
        context = context.addData((Object)"key2", (Object)"value2").addData((Object)"key1", (Object)"value3");
        reactorContext = FluxUtil.toReactorContext((Context)context);
        Assertions.assertEquals((int)2, (int)reactorContext.size());
        Assertions.assertTrue((boolean)reactorContext.hasKey((Object)"key1"));
        Assertions.assertEquals((Object)"value3", (Object)reactorContext.get((Object)"key1"));
        Assertions.assertTrue((boolean)reactorContext.hasKey((Object)"key2"));
        Assertions.assertEquals((Object)"value2", (Object)reactorContext.get((Object)"key2"));
    }

    @Test
    public void testIsFluxByteBufferInvalidType() {
        Assertions.assertFalse((boolean)FluxUtil.isFluxByteBuffer(Mono.class));
    }

    @Test
    public void testIsFluxByteBufferValidType() throws Exception {
        Method method = FluxUtilTest.class.getMethod("mockReturnType", new Class[0]);
        Type returnType = method.getGenericReturnType();
        Assertions.assertTrue((boolean)FluxUtil.isFluxByteBuffer((Type)returnType));
    }

    @Test
    public void testToMono() {
        String testValue = "some value";
        SimpleResponse response = new SimpleResponse(new HttpRequest(HttpMethod.GET, "http://www.test.com"), 202, new HttpHeaders(), (Object)testValue);
        StepVerifier.create((Publisher)FluxUtil.toMono((Response)response)).assertNext(val -> Assertions.assertEquals((Object)val, (Object)testValue)).verifyComplete();
    }

    @Test
    public void testMonoError() {
        String errMsg = "It is an error message";
        RuntimeException ex = new RuntimeException(errMsg);
        ClientLogger logger = new ClientLogger(FluxUtilTest.class);
        StepVerifier.create((Publisher)FluxUtil.monoError((ClientLogger)logger, (RuntimeException)ex)).verifyErrorMessage(errMsg);
    }

    @Test
    public void testFluxError() {
        String errMsg = "It is an error message";
        RuntimeException ex = new RuntimeException(errMsg);
        ClientLogger logger = new ClientLogger(FluxUtilTest.class);
        StepVerifier.create((Publisher)FluxUtil.fluxError((ClientLogger)logger, (RuntimeException)ex)).verifyErrorMessage(errMsg);
    }

    @Test
    public void testPageFluxError() {
        String errMsg = "It is an error message";
        RuntimeException ex = new RuntimeException(errMsg);
        ClientLogger logger = new ClientLogger(FluxUtilTest.class);
        StepVerifier.create((Publisher)FluxUtil.pagedFluxError((ClientLogger)logger, (RuntimeException)ex)).verifyErrorMessage(errMsg);
    }

    @Test
    public void testWriteFile() throws Exception {
        String toReplace = "test";
        String original = "hello there";
        String target = "testo there";
        Flux body = Flux.just((Object)ByteBuffer.wrap(toReplace.getBytes(StandardCharsets.UTF_8)));
        File file = this.createFileIfNotExist("target/test1");
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(original.getBytes(StandardCharsets.UTF_8));
        stream.close();
        try (AsynchronousFileChannel channel = AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.WRITE);){
            FluxUtil.writeFile((Flux)body, (AsynchronousFileChannel)channel).block();
            byte[] outputStream = Files.readAllBytes(file.toPath());
            Assertions.assertTrue((boolean)Arrays.equals(outputStream, target.getBytes(StandardCharsets.UTF_8)));
        }
    }

    public Flux<ByteBuffer> mockReturnType() {
        return Flux.just((Object)ByteBuffer.wrap(new byte[0]));
    }

    private Mono<String> getSingle() {
        return FluxUtil.withContext(this::serviceCallSingle);
    }

    private Flux<String> getCollection() {
        return FluxUtil.fluxContext(this::serviceCallCollection);
    }

    private Mono<String> serviceCallSingle(Context context) {
        String msg = "Hello, " + context.getData((Object)"FirstName").orElse("Stranger") + " " + context.getData((Object)"LastName").orElse("");
        return Mono.just((Object)msg);
    }

    private Flux<String> serviceCallCollection(Context context) {
        String msg = "Hello, " + context.getData((Object)"FirstName").orElse("Stranger") + " " + context.getData((Object)"LastName").orElse("");
        return Flux.just((Object[])msg.split(" "));
    }

    private File createFileIfNotExist(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        return file;
    }
}

