/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.CoreUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CoreUtilsTests {
    @Test
    public void findFirstOfTypeEmptyArgs() {
        Assertions.assertNull((Object)CoreUtils.findFirstOfType(null, Integer.class));
    }

    @Test
    public void findFirstOfTypeWithOneOfType() {
        int expected = 1;
        Object[] args = new Object[]{"string", expected};
        int actual = (Integer)CoreUtils.findFirstOfType((Object[])args, Integer.class);
        Assertions.assertEquals((int)expected, (int)actual);
    }

    @Test
    public void findFirstOfTypeWithMultipleOfType() {
        int expected = 1;
        Object[] args = new Object[]{"string", expected, 10};
        int actual = (Integer)CoreUtils.findFirstOfType((Object[])args, Integer.class);
        Assertions.assertEquals((int)expected, (int)actual);
    }

    @Test
    public void findFirstOfTypeWithNoneOfType() {
        Object[] args = new Object[]{"string", "anotherString"};
        Assertions.assertNull((Object)CoreUtils.findFirstOfType((Object[])args, Integer.class));
    }

    @Test
    public void testProperties() {
        Assertions.assertNotNull(CoreUtils.getProperties((String)"azure-core.properties").get("version"));
        Assertions.assertNotNull(CoreUtils.getProperties((String)"azure-core.properties").get("name"));
        Assertions.assertTrue((boolean)((String)CoreUtils.getProperties((String)"azure-core.properties").get("version")).matches("\\d.\\d.\\d([-a-zA-Z0-9.])*"));
    }

    @Test
    public void testMissingProperties() {
        Assertions.assertNotNull((Object)CoreUtils.getProperties((String)"foo.properties"));
        Assertions.assertTrue((boolean)CoreUtils.getProperties((String)"foo.properties").isEmpty());
        Assertions.assertNull(CoreUtils.getProperties((String)"azure-core.properties").get("foo"));
    }
}

