/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer.jsonwrapper;

import com.azure.core.implementation.serializer.jsonwrapper.Car;
import com.azure.core.implementation.serializer.jsonwrapper.Foo;
import com.azure.core.implementation.serializer.jsonwrapper.FooWithInner;
import com.azure.core.implementation.serializer.jsonwrapper.GenericFoo;
import com.azure.core.implementation.serializer.jsonwrapper.api.Config;
import com.azure.core.implementation.serializer.jsonwrapper.api.Deserializer;
import com.azure.core.implementation.serializer.jsonwrapper.api.JsonApi;
import com.azure.core.implementation.serializer.jsonwrapper.api.Node;
import com.azure.core.implementation.serializer.jsonwrapper.api.Type;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class JsonDeserializationTests {
    protected JsonApi jsonApi;

    @Test
    public void deserializeString() {
        String json = "{ \"color\" : \"Black\", \"type\" : \"BMW\" }";
        Car car = (Car)this.jsonApi.readString(json, Car.class);
        Assertions.assertNotNull((Object)car);
        Assertions.assertEquals((Object)"Black", (Object)car.getColor());
        Assertions.assertEquals((Object)"BMW", (Object)car.getType());
    }

    @Test
    public void deserializeListString() {
        String json = "[{ \"color\" : \"Black\", \"type\" : \"BMW\" }, { \"color\" : \"Red\", \"type\" : \"FIAT\" }]";
        List cars = this.jsonApi.readStringToList(json, (Type)new Type<List<Car>>(){});
        Assertions.assertNotNull((Object)cars);
        Assertions.assertEquals((int)2, (int)cars.size());
        Assertions.assertEquals((Object)"Black", (Object)((Car)cars.get(0)).getColor());
        Assertions.assertEquals((Object)"BMW", (Object)((Car)cars.get(0)).getType());
        Assertions.assertEquals((Object)"Red", (Object)((Car)cars.get(1)).getColor());
        Assertions.assertEquals((Object)"FIAT", (Object)((Car)cars.get(1)).getType());
    }

    @Test
    public void whenDeserializingToSimpleObjectThenCorrect() {
        String json = "{\"intValue\":1,\"stringValue\":\"one\"}";
        Foo targetObject = (Foo)this.jsonApi.readString(json, Foo.class);
        Assertions.assertEquals((int)targetObject.getIntValue(), (int)1);
        Assertions.assertEquals((Object)targetObject.getStringValue(), (Object)"one");
    }

    @Test
    public void whenDeserializingToGenericObjectThenCorrect() {
        String json = "{\"theValue\":1}";
        GenericFoo targetObject = (GenericFoo)this.jsonApi.readString(json, (Type)new Type<GenericFoo<Integer>>(){});
        Assertions.assertEquals((Integer)((Integer)targetObject.getTheValue()), (Integer)new Integer(1));
    }

    @Test
    public void givenJsonHasExtraValuesWhenDeserializingThenCorrect() {
        this.jsonApi.configure(Config.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String json = "{\"intValue\":1,\"stringValue\":\"one\",\"extraString\":\"two\",\"extraFloat\":2.2}";
        Foo targetObject = (Foo)this.jsonApi.readString(json, Foo.class);
        Assertions.assertEquals((int)targetObject.getIntValue(), (int)1);
        Assertions.assertEquals((Object)targetObject.getStringValue(), (Object)"one");
    }

    @Test
    public void givenJsonHasNonMatchingFieldsWhenDeserializingWithCustomDeserializerThenCorrect() {
        String json = "{\"valueInt\":7,\"valueString\":\"seven\"}";
        this.jsonApi.registerCustomDeserializer((Deserializer)new Deserializer<Foo>(Foo.class){

            public Foo deserialize(Node node) {
                int intValue = node.get("valueInt").asInt();
                String stringValue = node.get("valueString").asString();
                return new Foo(intValue, stringValue);
            }
        });
        Foo targetObject = (Foo)this.jsonApi.readString(json, Foo.class);
        Assertions.assertEquals((int)targetObject.getIntValue(), (int)7);
        Assertions.assertEquals((Object)targetObject.getStringValue(), (Object)"seven");
    }

    @Test
    public void customDeserializeCar() {
        String json = "{ \"color\" : \"Black\", \"type\" : \"BMW\" }";
        this.jsonApi.registerCustomDeserializer((Deserializer)new Deserializer<Car>(Car.class){

            public Car deserialize(Node node) {
                Car car = new Car();
                Node colorNode = node.get("color");
                String color = colorNode.asString();
                car.setColor(color);
                return car;
            }
        });
        Car car = (Car)this.jsonApi.readString(json, Car.class);
        Assertions.assertEquals((Object)car.getColor(), (Object)"Black");
        Assertions.assertNull((Object)car.getType());
    }

    @Test
    public void givenJsonArrayOfFoosWhenDeserializingToArrayThenCorrect() {
        String json = "[{\"intValue\":1,\"stringValue\":\"one\"},{\"intValue\":2,\"stringValue\":\"two\"}]";
        Foo[] targetArray = (Foo[])this.jsonApi.readString(json, Foo[].class);
        Assertions.assertEquals((int)2, (int)targetArray.length);
        Assertions.assertEquals((Object)new Foo(1, "one"), (Object)targetArray[0]);
        Assertions.assertEquals((Object)new Foo(2, "two"), (Object)targetArray[1]);
    }

    @Test
    public void givenJsonArrayOfFoosWhenDeserializingCollectionThenCorrect() {
        String json = "[{\"intValue\":1,\"stringValue\":\"one\"},{\"intValue\":2,\"stringValue\":\"two\"}]";
        Type<List<Foo>> targetClassType = new Type<List<Foo>>(){};
        List targetList = this.jsonApi.readStringToList(json, (Type)targetClassType);
        Assertions.assertEquals((int)2, (int)targetList.size());
        Assertions.assertEquals((Object)new Foo(1, "one"), targetList.get(0));
        Assertions.assertEquals((Object)new Foo(2, "two"), targetList.get(1));
    }

    @Test
    public void whenDeserializingToNestedObjectsThenCorrect() {
        String json = "{\"intValue\":1,\"stringValue\":\"one\",\"innerFoo\":{\"name\":\"inner\"}}";
        FooWithInner targetObject = (FooWithInner)this.jsonApi.readString(json, FooWithInner.class);
        Assertions.assertEquals((int)targetObject.getIntValue(), (int)1);
        Assertions.assertEquals((Object)targetObject.getStringValue(), (Object)"one");
        Assertions.assertEquals((Object)targetObject.getInnerFoo().getName(), (Object)"inner");
    }
}

