/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer.jsonwrapper;

import com.azure.core.implementation.serializer.jsonwrapper.Entry;
import com.azure.core.implementation.serializer.jsonwrapper.Foo;
import com.azure.core.implementation.serializer.jsonwrapper.JsonDeserializationTests;
import com.azure.core.implementation.serializer.jsonwrapper.JsonWrapper;
import com.azure.core.implementation.serializer.jsonwrapper.api.Config;
import com.azure.core.implementation.serializer.jsonwrapper.jacksonwrapper.JacksonDeserializer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JacksonDeserializationTests
extends JsonDeserializationTests {
    @BeforeEach
    public void initialize() throws Exception {
        this.jsonApi = JsonWrapper.newInstance(JacksonDeserializer.class);
        Assertions.assertNotNull((Object)this.jsonApi);
        this.jsonApi.configure(Config.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Test
    public void deserializeDate() throws ParseException {
        String json = "{ \"date\" : \"1970-01-18T00:00:00Z\"}";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Date date = dateFormat.parse("1970-01-18T00:00:00Z");
        this.jsonApi.configureTimezone();
        Entry entry = (Entry)this.jsonApi.readString(json, Entry.class);
        Assertions.assertEquals((Object)date, (Object)entry.date());
    }

    @Test
    public void convertMap2Object() {
        HashMap<String, Object> document = new HashMap<String, Object>();
        document.put("intValue", 1);
        document.put("stringValue", "one");
        Foo expected = new Foo();
        expected.setIntValue(1);
        expected.setStringValue("one");
        Foo actual = (Foo)this.jsonApi.convertObjectToType(document, Foo.class);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

