/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http;

import com.azure.core.util.UrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlBuilderTests {
    @Test
    public void scheme() {
        UrlBuilder builder = new UrlBuilder().setScheme("http");
        Assertions.assertEquals((Object)"http://", (Object)builder.toString());
    }

    @Test
    public void schemeWhenSchemeIsNull() {
        UrlBuilder builder = new UrlBuilder().setScheme("http");
        builder.setScheme(null);
        Assertions.assertNull((Object)builder.getScheme());
    }

    @Test
    public void schemeWhenSchemeIsEmpty() {
        UrlBuilder builder = new UrlBuilder().setScheme("http");
        builder.setScheme("");
        Assertions.assertNull((Object)builder.getScheme());
    }

    @Test
    public void schemeWhenSchemeIsNotEmpty() {
        UrlBuilder builder = new UrlBuilder().setScheme("http");
        builder.setScheme("https");
        Assertions.assertEquals((Object)"https", (Object)builder.getScheme());
    }

    @Test
    public void schemeWhenSchemeContainsTerminator() {
        UrlBuilder builder = new UrlBuilder().setScheme("http://");
        Assertions.assertEquals((Object)"http", (Object)builder.getScheme());
        Assertions.assertNull((Object)builder.getHost());
        Assertions.assertEquals((Object)"http://", (Object)builder.toString());
    }

    @Test
    public void schemeWhenSchemeContainsHost() {
        UrlBuilder builder = new UrlBuilder().setScheme("http://www.example.com");
        Assertions.assertEquals((Object)"http", (Object)builder.getScheme());
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertEquals((Object)"http://www.example.com", (Object)builder.toString());
    }

    @Test
    public void schemeAndHost() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.example.com");
        Assertions.assertEquals((Object)"http://www.example.com", (Object)builder.toString());
    }

    @Test
    public void schemeAndHostWhenHostHasWhitespace() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.exa mple.com");
        Assertions.assertEquals((Object)"http://www.exa mple.com", (Object)builder.toString());
    }

    @Test
    public void host() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com");
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.toString());
    }

    @Test
    public void hostWhenHostIsNull() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com");
        builder.setHost(null);
        Assertions.assertNull((Object)builder.getHost());
    }

    @Test
    public void hostWhenHostIsEmpty() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com");
        builder.setHost("");
        Assertions.assertNull((Object)builder.getHost());
    }

    @Test
    public void hostWhenHostIsNotEmpty() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com");
        builder.setHost("www.bing.com");
        Assertions.assertEquals((Object)"www.bing.com", (Object)builder.getHost());
    }

    @Test
    public void hostWhenHostContainsSchemeTerminator() {
        UrlBuilder builder = new UrlBuilder().setHost("://www.example.com");
        Assertions.assertNull((Object)builder.getScheme());
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.toString());
    }

    @Test
    public void hostWhenHostContainsScheme() {
        UrlBuilder builder = new UrlBuilder().setHost("https://www.example.com");
        Assertions.assertEquals((Object)"https", (Object)builder.getScheme());
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertEquals((Object)"https://www.example.com", (Object)builder.toString());
    }

    @Test
    public void hostWhenHostContainsColonButNoPort() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com:");
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertNull((Object)builder.getPort());
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.toString());
    }

    @Test
    public void hostWhenHostContainsPort() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com:1234");
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertEquals((int)1234, (int)builder.getPort());
        Assertions.assertEquals((Object)"www.example.com:1234", (Object)builder.toString());
    }

    @Test
    public void hostWhenHostContainsForwardSlashButNoPath() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com/");
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertEquals((Object)"/", (Object)builder.getPath());
        Assertions.assertEquals((Object)"www.example.com/", (Object)builder.toString());
    }

    @Test
    public void hostWhenHostContainsPath() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com/index.html");
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertEquals((Object)"/index.html", (Object)builder.getPath());
        Assertions.assertEquals((Object)"www.example.com/index.html", (Object)builder.toString());
    }

    @Test
    public void hostWhenHostContainsQuestionMarkButNoQuery() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com?");
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertEquals((int)0, (int)builder.getQuery().size());
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.toString());
    }

    @Test
    public void hostWhenHostContainsQuery() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com?a=b");
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        MatcherAssert.assertThat((Object)builder.toString(), (Matcher)CoreMatchers.containsString((String)"a=b"));
        Assertions.assertEquals((Object)"www.example.com?a=b", (Object)builder.toString());
    }

    @Test
    public void hostWhenHostHasWhitespace() {
        UrlBuilder builder = new UrlBuilder().setHost("www.exampl e.com");
        Assertions.assertEquals((Object)"www.exampl e.com", (Object)builder.toString());
    }

    @Test
    public void hostAndPath() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com").setPath("my/path");
        Assertions.assertEquals((Object)"www.example.com/my/path", (Object)builder.toString());
    }

    @Test
    public void hostAndPathWithSlashAfterHost() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com/").setPath("my/path");
        Assertions.assertEquals((Object)"www.example.com/my/path", (Object)builder.toString());
    }

    @Test
    public void hostAndPathWithSlashBeforePath() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com").setPath("/my/path");
        Assertions.assertEquals((Object)"www.example.com/my/path", (Object)builder.toString());
    }

    @Test
    public void hostAndPathWithSlashAfterHostAndBeforePath() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com/").setPath("/my/path");
        Assertions.assertEquals((Object)"www.example.com/my/path", (Object)builder.toString());
    }

    @Test
    public void hostAndPathWithWhitespaceInPath() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com").setPath("my path");
        Assertions.assertEquals((Object)"www.example.com/my path", (Object)builder.toString());
    }

    @Test
    public void hostAndPathWithPlusInPath() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com").setPath("my+path");
        Assertions.assertEquals((Object)"www.example.com/my+path", (Object)builder.toString());
    }

    @Test
    public void hostAndPathWithPercent20InPath() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com").setPath("my%20path");
        Assertions.assertEquals((Object)"www.example.com/my%20path", (Object)builder.toString());
    }

    @Test
    public void portInt() {
        UrlBuilder builder = new UrlBuilder().setPort(50);
        Assertions.assertEquals((int)50, (int)builder.getPort());
        Assertions.assertEquals((Object)":50", (Object)builder.toString());
    }

    @Test
    public void portStringWithNull() {
        UrlBuilder builder = new UrlBuilder().setPort(null);
        Assertions.assertNull((Object)builder.getPort());
        Assertions.assertEquals((Object)"", (Object)builder.toString());
    }

    @Test
    public void portStringWithEmpty() {
        UrlBuilder builder = new UrlBuilder().setPort("");
        Assertions.assertNull((Object)builder.getPort());
        Assertions.assertEquals((Object)"", (Object)builder.toString());
    }

    @Test
    public void portString() {
        UrlBuilder builder = new UrlBuilder().setPort("50");
        Assertions.assertEquals((int)50, (int)builder.getPort());
        Assertions.assertEquals((Object)":50", (Object)builder.toString());
    }

    @Test
    public void portStringWithForwardSlashButNoPath() {
        UrlBuilder builder = new UrlBuilder().setPort("50/");
        Assertions.assertEquals((int)50, (int)builder.getPort());
        Assertions.assertEquals((Object)"/", (Object)builder.getPath());
        Assertions.assertEquals((Object)":50/", (Object)builder.toString());
    }

    @Test
    public void portStringpath() {
        UrlBuilder builder = new UrlBuilder().setPort("50/index.html");
        Assertions.assertEquals((int)50, (int)builder.getPort());
        Assertions.assertEquals((Object)"/index.html", (Object)builder.getPath());
        Assertions.assertEquals((Object)":50/index.html", (Object)builder.toString());
    }

    @Test
    public void portStringWithQuestionMarkButNoQuery() {
        UrlBuilder builder = new UrlBuilder().setPort("50?");
        Assertions.assertEquals((int)50, (int)builder.getPort());
        Assertions.assertEquals((int)0, (int)builder.getQuery().size());
        Assertions.assertEquals((Object)":50", (Object)builder.toString());
    }

    @Test
    public void portStringquery() {
        UrlBuilder builder = new UrlBuilder().setPort("50?a=b&c=d");
        Assertions.assertEquals((int)50, (int)builder.getPort());
        MatcherAssert.assertThat((Object)builder.toString(), (Matcher)CoreMatchers.containsString((String)"?a=b&c=d"));
        Assertions.assertEquals((Object)":50?a=b&c=d", (Object)builder.toString());
    }

    @Test
    public void portStringWhenPortIsNull() {
        UrlBuilder builder = new UrlBuilder().setPort(8080);
        builder.setPort(null);
        Assertions.assertNull((Object)builder.getPort());
    }

    @Test
    public void portStringWhenPortIsEmpty() {
        UrlBuilder builder = new UrlBuilder().setPort(8080);
        builder.setPort("");
        Assertions.assertNull((Object)builder.getPort());
    }

    @Test
    public void portStringWhenPortIsNotEmpty() {
        UrlBuilder builder = new UrlBuilder().setPort(8080);
        builder.setPort("123");
        Assertions.assertEquals((int)123, (int)builder.getPort());
    }

    @Test
    public void schemeAndHostAndOneQueryParameter() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.example.com").setQueryParameter("A", "B");
        Assertions.assertEquals((Object)"http://www.example.com?A=B", (Object)builder.toString());
    }

    @Test
    public void schemeAndHostAndOneQueryParameterWhenQueryParameterNameHasWhitespace() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.example.com").setQueryParameter("App les", "B");
        Assertions.assertEquals((Object)"http://www.example.com?App les=B", (Object)builder.toString());
    }

    @Test
    public void schemeAndHostAndOneQueryParameterWhenQueryParameterNameHasPercent20() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.example.com").setQueryParameter("App%20les", "B");
        Assertions.assertEquals((Object)"http://www.example.com?App%20les=B", (Object)builder.toString());
    }

    @Test
    public void schemeAndHostAndOneQueryParameterWhenQueryParameterValueHasWhitespace() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.example.com").setQueryParameter("Apples", "Go od");
        Assertions.assertEquals((Object)"http://www.example.com?Apples=Go od", (Object)builder.toString());
    }

    @Test
    public void schemeAndHostAndOneQueryParameterWhenQueryParameterValueHasPercent20() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.example.com").setQueryParameter("Apples", "Go%20od");
        Assertions.assertEquals((Object)"http://www.example.com?Apples=Go%20od", (Object)builder.toString());
    }

    @Test
    public void schemeAndHostAndTwoQueryParameters() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.example.com").setQueryParameter("A", "B").setQueryParameter("C", "D");
        Assertions.assertEquals((Object)"http://www.example.com?A=B&C=D", (Object)builder.toString());
    }

    @Test
    public void schemeAndHostAndPathAndTwoQueryParameters() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.example.com").setQueryParameter("A", "B").setQueryParameter("C", "D").setPath("index.html");
        Assertions.assertEquals((Object)"http://www.example.com/index.html?A=B&C=D", (Object)builder.toString());
    }

    @Test
    public void pathWhenBuilderPathIsNullAndPathIsNull() {
        UrlBuilder builder = new UrlBuilder();
        builder.setPath(null);
        Assertions.assertNull((Object)builder.getPath());
    }

    @Test
    public void pathWhenBuilderPathIsNullAndPathIsEmptyString() {
        UrlBuilder builder = new UrlBuilder();
        builder.setPath("");
        Assertions.assertNull((Object)builder.getPath());
    }

    @Test
    public void pathWhenBuilderPathIsNullAndPathIsForwardSlash() {
        UrlBuilder builder = new UrlBuilder();
        builder.setPath("/");
        Assertions.assertEquals((Object)"/", (Object)builder.getPath());
    }

    @Test
    public void pathWhenBuilderPathIsNullAndPath() {
        UrlBuilder builder = new UrlBuilder();
        builder.setPath("test/path.html");
        Assertions.assertEquals((Object)"test/path.html", (Object)builder.getPath());
    }

    @Test
    public void pathWhenBuilderPathIsForwardSlashAndPathIsNull() {
        UrlBuilder builder = new UrlBuilder().setPath("/");
        builder.setPath(null);
        Assertions.assertNull((Object)builder.getPath());
    }

    @Test
    public void pathWhenBuilderPathIsForwardSlashAndPathIsEmptyString() {
        UrlBuilder builder = new UrlBuilder().setPath("/");
        builder.setPath("");
        Assertions.assertNull((Object)builder.getPath());
    }

    @Test
    public void pathWhenBuilderPathIsForwardSlashAndPathIsForwardSlash() {
        UrlBuilder builder = new UrlBuilder().setPath("/");
        builder.setPath("/");
        Assertions.assertEquals((Object)"/", (Object)builder.getPath());
    }

    @Test
    public void pathWhenBuilderPathIsForwardSlashAndPath() {
        UrlBuilder builder = new UrlBuilder().setPath("/");
        builder.setPath("test/path.html");
        Assertions.assertEquals((Object)"test/path.html", (Object)builder.getPath());
    }

    @Test
    public void pathWhenHostContainsPath() {
        UrlBuilder builder = new UrlBuilder().setHost("www.example.com/site").setPath("index.html");
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertEquals((Object)"index.html", (Object)builder.getPath());
        Assertions.assertEquals((Object)"www.example.com/index.html", (Object)builder.toString());
    }

    @Test
    public void pathFirstWhenHostContainsPath() {
        UrlBuilder builder = new UrlBuilder().setPath("index.html").setHost("www.example.com/site");
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertEquals((Object)"/site", (Object)builder.getPath());
        Assertions.assertEquals((Object)"www.example.com/site", (Object)builder.toString());
    }

    @Test
    public void emptyPathWhenHostContainsPath() {
        UrlBuilder builder = new UrlBuilder().setPath("").setHost("www.example.com/site");
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertEquals((Object)"/site", (Object)builder.getPath());
        Assertions.assertEquals((Object)"www.example.com/site", (Object)builder.toString());
    }

    @Test
    public void slashPathWhenHostContainsPath() {
        UrlBuilder builder = new UrlBuilder().setPath("//").setHost("www.example.com/site");
        Assertions.assertEquals((Object)"www.example.com", (Object)builder.getHost());
        Assertions.assertEquals((Object)"/site", (Object)builder.getPath());
        Assertions.assertEquals((Object)"www.example.com/site", (Object)builder.toString());
    }

    @Test
    public void withAbsolutePath() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.example.com").setPath("http://www.othersite.com");
        Assertions.assertEquals((Object)"http://www.othersite.com", (Object)builder.toString());
    }

    @Test
    public void queryInPath() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.example.com").setPath("mypath?thing=stuff").setQueryParameter("otherthing", "otherstuff");
        Assertions.assertEquals((Object)"http://www.example.com/mypath?thing=stuff&otherthing=otherstuff", (Object)builder.toString());
    }

    @Test
    public void withAbsolutePathAndQuery() {
        UrlBuilder builder = new UrlBuilder().setScheme("http").setHost("www.example.com").setPath("http://www.othersite.com/mypath?thing=stuff").setQueryParameter("otherthing", "otherstuff");
        Assertions.assertEquals((Object)"http://www.othersite.com/mypath?thing=stuff&otherthing=otherstuff", (Object)builder.toString());
    }

    @Test
    public void queryWithNull() {
        UrlBuilder builder = new UrlBuilder().setQuery(null);
        Assertions.assertEquals((int)0, (int)builder.getQuery().size());
        Assertions.assertEquals((Object)"", (Object)builder.toString());
    }

    @Test
    public void queryWithEmpty() {
        UrlBuilder builder = new UrlBuilder().setQuery("");
        Assertions.assertEquals((int)0, (int)builder.getQuery().size());
        Assertions.assertEquals((Object)"", (Object)builder.toString());
    }

    @Test
    public void queryWithQuestionMark() {
        UrlBuilder builder = new UrlBuilder().setQuery("?");
        Assertions.assertEquals((int)0, (int)builder.getQuery().size());
        Assertions.assertEquals((Object)"", (Object)builder.toString());
    }

    @Test
    public void parseWithNullString() {
        UrlBuilder builder = UrlBuilder.parse((String)null);
        Assertions.assertEquals((Object)"", (Object)builder.toString());
    }

    @Test
    public void parseWithEmpty() {
        UrlBuilder builder = UrlBuilder.parse((String)"");
        Assertions.assertEquals((Object)"", (Object)builder.toString());
    }

    @Test
    public void parsehost() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com");
        Assertions.assertEquals((Object)"www.bing.com", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHost() {
        UrlBuilder builder = UrlBuilder.parse((String)"https://www.bing.com");
        Assertions.assertEquals((Object)"https://www.bing.com", (Object)builder.toString());
    }

    @Test
    public void parsehostAndPort() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com:8080");
        Assertions.assertEquals((Object)"www.bing.com:8080", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHostAndPort() {
        UrlBuilder builder = UrlBuilder.parse((String)"ftp://www.bing.com:8080");
        Assertions.assertEquals((Object)"ftp://www.bing.com:8080", (Object)builder.toString());
    }

    @Test
    public void parsehostAndPath() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com/my/path");
        Assertions.assertEquals((Object)"www.bing.com/my/path", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHostAndPath() {
        UrlBuilder builder = UrlBuilder.parse((String)"ftp://www.bing.com/my/path");
        Assertions.assertEquals((Object)"ftp://www.bing.com/my/path", (Object)builder.toString());
    }

    @Test
    public void parsehostAndPortAndPath() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com:1234/my/path");
        Assertions.assertEquals((Object)"www.bing.com:1234/my/path", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHostAndPortAndPath() {
        UrlBuilder builder = UrlBuilder.parse((String)"ftp://www.bing.com:2345/my/path");
        Assertions.assertEquals((Object)"ftp://www.bing.com:2345/my/path", (Object)builder.toString());
    }

    @Test
    public void parsehostAndOneQueryParameter() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com?a=1");
        Assertions.assertEquals((Object)"www.bing.com?a=1", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHostAndOneQueryParameter() {
        UrlBuilder builder = UrlBuilder.parse((String)"https://www.bing.com?a=1");
        Assertions.assertEquals((Object)"https://www.bing.com?a=1", (Object)builder.toString());
    }

    @Test
    public void parsehostAndPortAndOneQueryParameter() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com:123?a=1");
        Assertions.assertEquals((Object)"www.bing.com:123?a=1", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHostAndPortAndOneQueryParameter() {
        UrlBuilder builder = UrlBuilder.parse((String)"https://www.bing.com:987?a=1");
        Assertions.assertEquals((Object)"https://www.bing.com:987?a=1", (Object)builder.toString());
    }

    @Test
    public void parsehostAndPathAndOneQueryParameter() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com/folder/index.html?a=1");
        Assertions.assertEquals((Object)"www.bing.com/folder/index.html?a=1", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHostAndPathAndOneQueryParameter() {
        UrlBuilder builder = UrlBuilder.parse((String)"https://www.bing.com/image.gif?a=1");
        Assertions.assertEquals((Object)"https://www.bing.com/image.gif?a=1", (Object)builder.toString());
    }

    @Test
    public void parsehostAndPortAndPathAndOneQueryParameter() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com:123/index.html?a=1");
        Assertions.assertEquals((Object)"www.bing.com:123/index.html?a=1", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHostAndPortAndPathAndOneQueryParameter() {
        UrlBuilder builder = UrlBuilder.parse((String)"https://www.bing.com:987/my/path/again?a=1");
        Assertions.assertEquals((Object)"https://www.bing.com:987/my/path/again?a=1", (Object)builder.toString());
    }

    @Test
    public void parsehostAndTwoQueryParameters() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com?a=1&b=2");
        Assertions.assertEquals((Object)"www.bing.com?a=1&b=2", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHostAndTwoQueryParameters() {
        UrlBuilder builder = UrlBuilder.parse((String)"https://www.bing.com?a=1&b=2");
        Assertions.assertEquals((Object)"https://www.bing.com?a=1&b=2", (Object)builder.toString());
    }

    @Test
    public void parsehostAndPortAndTwoQueryParameters() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com:123?a=1&b=2");
        Assertions.assertEquals((Object)"www.bing.com:123?a=1&b=2", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHostAndPortAndTwoQueryParameters() {
        UrlBuilder builder = UrlBuilder.parse((String)"https://www.bing.com:987?a=1&b=2");
        Assertions.assertEquals((Object)"https://www.bing.com:987?a=1&b=2", (Object)builder.toString());
    }

    @Test
    public void parsehostAndPathAndTwoQueryParameters() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com/folder/index.html?a=1&b=2");
        Assertions.assertEquals((Object)"www.bing.com/folder/index.html?a=1&b=2", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHostAndPathAndTwoQueryParameters() {
        UrlBuilder builder = UrlBuilder.parse((String)"https://www.bing.com/image.gif?a=1&b=2");
        Assertions.assertEquals((Object)"https://www.bing.com/image.gif?a=1&b=2", (Object)builder.toString());
    }

    @Test
    public void parsehostAndPortAndPathAndTwoQueryParameters() {
        UrlBuilder builder = UrlBuilder.parse((String)"www.bing.com:123/index.html?a=1&b=2");
        Assertions.assertEquals((Object)"www.bing.com:123/index.html?a=1&b=2", (Object)builder.toString());
    }

    @Test
    public void parseWithProtocolAndHostAndPortAndPathAndTwoQueryParameters() {
        UrlBuilder builder = UrlBuilder.parse((String)"https://www.bing.com:987/my/path/again?a=1&b=2");
        Assertions.assertEquals((Object)"https://www.bing.com:987/my/path/again?a=1&b=2", (Object)builder.toString());
    }

    @Test
    public void parseWithColonInPath() {
        UrlBuilder builder = UrlBuilder.parse((String)"https://www.bing.com/my:/path");
        Assertions.assertEquals((Object)"https://www.bing.com/my:/path", (Object)builder.toString());
    }

    @Test
    public void parseURLWithNull() {
        UrlBuilder builder = UrlBuilder.parse((URL)null);
        Assertions.assertEquals((Object)"", (Object)builder.toString());
    }

    @Test
    public void parseURLschemeAndHost() throws MalformedURLException {
        UrlBuilder builder = UrlBuilder.parse((URL)new URL("http://www.bing.com"));
        Assertions.assertEquals((Object)"http://www.bing.com", (Object)builder.toString());
    }
}

