/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class HttpResponseTests {
    @Test
    public void testBufferedResponseSubscribeOnceAndDoDeepCopy() {
        SelfDisposedHttpResponse sourceHttpResponse = new SelfDisposedHttpResponse();
        Flux bufferedContentFlux = sourceHttpResponse.buffer().getBody();
        Flux zipped = bufferedContentFlux.zipWith(sourceHttpResponse.getInnerContentFlux());
        StepVerifier.create((Publisher)zipped).thenConsumeWhile(o -> {
            Assertions.assertFalse((o.getT1() == o.getT2() ? 1 : 0) != 0, (String)"Buffered response should not cache shallow copy of source.");
            return true;
        }).verifyComplete();
    }

    private static class SelfDisposedHttpResponse
    extends HttpResponse {
        private final Mono<ByteBuffer> contentMono;
        private final HttpHeaders headers = new HttpHeaders();
        private volatile boolean consumed;

        protected SelfDisposedHttpResponse() {
            super(new HttpRequest(HttpMethod.GET, "http://localhost"));
            this.contentMono = Mono.just((Object)ByteBuffer.wrap("long_long_content".getBytes()));
        }

        Flux<ByteBuffer> getInnerContentFlux() {
            return this.contentMono.flux();
        }

        public int getStatusCode() {
            return 200;
        }

        public String getHeaderValue(String name) {
            return null;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Flux<ByteBuffer> getBody() {
            return this.contentMono.doOnNext(bb -> {
                Assertions.assertFalse((boolean)this.consumed, (String)"content is already consumed");
                this.consumed = true;
            }).flux();
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return this.getBody().map(bb -> new byte[bb.remaining()]).next();
        }

        public Mono<String> getBodyAsString() {
            throw new RuntimeException("Not implemented");
        }

        public Mono<String> getBodyAsString(Charset charset) {
            throw new RuntimeException("Not implemented");
        }
    }
}

