/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TypeUtilTests {
    @Test
    public void testGetClasses() {
        Puppy puppy = new Puppy();
        List classes = TypeUtil.getAllClasses(puppy.getClass());
        Assertions.assertEquals((int)4, (int)classes.size());
        Assertions.assertTrue((boolean)classes.contains(Puppy.class));
        Assertions.assertTrue((boolean)classes.contains(Dog.class));
        Assertions.assertTrue((boolean)classes.contains(Pet.class));
        Assertions.assertTrue((boolean)classes.contains(Object.class));
    }

    @Test
    public void testGetTypeArguments() {
        Type[] puppyArgs = TypeUtil.getTypeArguments(Puppy.class);
        Type[] dogArgs = TypeUtil.getTypeArguments((Type)Puppy.class.getGenericSuperclass());
        Type[] petArgs = TypeUtil.getTypeArguments((Type)Dog.class.getGenericSuperclass());
        Assertions.assertEquals((int)0, (int)puppyArgs.length);
        Assertions.assertEquals((int)1, (int)dogArgs.length);
        Assertions.assertEquals((int)2, (int)petArgs.length);
    }

    @Test
    public void testGetTypeArgument() {
        Type dogArgs = TypeUtil.getTypeArgument((Type)Puppy.class.getGenericSuperclass());
        Assertions.assertEquals(Kid.class, (Object)dogArgs);
    }

    @Test
    public void testGetRawClass() {
        Type petType = Puppy.class.getSuperclass().getGenericSuperclass();
        Assertions.assertEquals(Pet.class, (Object)TypeUtil.getRawClass((Type)petType));
    }

    @Test
    public void testGetSuperType() {
        Type dogType = TypeUtil.getSuperType(Puppy.class);
        Type petType = TypeUtil.getSuperType((Type)dogType);
        Type[] arguments = TypeUtil.getTypeArguments((Type)petType);
        Assertions.assertEquals((int)2, (int)arguments.length);
        Assertions.assertEquals(Kid.class, (Object)arguments[0]);
        Assertions.assertEquals(String.class, (Object)arguments[1]);
    }

    @Test
    public void testGetTopSuperType() {
        Type petType = TypeUtil.getSuperType(Puppy.class, Pet.class);
        Type[] arguments = TypeUtil.getTypeArguments((Type)petType);
        Assertions.assertEquals((int)2, (int)arguments.length);
        Assertions.assertEquals(Kid.class, (Object)arguments[0]);
        Assertions.assertEquals(String.class, (Object)arguments[1]);
    }

    @Test
    public void testIsTypeOrSubTypeOf() {
        Type dogType = TypeUtil.getSuperType(Puppy.class);
        Type petType = TypeUtil.getSuperType((Type)dogType);
        Assertions.assertTrue((boolean)TypeUtil.isTypeOrSubTypeOf(Puppy.class, (Type)dogType));
        Assertions.assertTrue((boolean)TypeUtil.isTypeOrSubTypeOf(Puppy.class, Puppy.class));
        Assertions.assertTrue((boolean)TypeUtil.isTypeOrSubTypeOf(Puppy.class, (Type)petType));
        Assertions.assertTrue((boolean)TypeUtil.isTypeOrSubTypeOf((Type)dogType, (Type)petType));
        Assertions.assertTrue((boolean)TypeUtil.isTypeOrSubTypeOf((Type)dogType, (Type)dogType));
        Assertions.assertTrue((boolean)TypeUtil.isTypeOrSubTypeOf((Type)petType, (Type)petType));
    }

    @Test
    public void testCreateParameterizedType() {
        Type dogType = TypeUtil.getSuperType(Puppy.class);
        Type petType = TypeUtil.getSuperType((Type)dogType);
        ParameterizedType createdType = TypeUtil.createParameterizedType(Pet.class, (Type[])new Type[]{Kid.class, String.class});
        Assertions.assertEquals((Object)TypeUtil.getRawClass((Type)petType), (Object)TypeUtil.getRawClass((Type)createdType));
        Assertions.assertArrayEquals((Object[])TypeUtil.getTypeArguments((Type)petType), (Object[])TypeUtil.getTypeArguments((Type)createdType));
    }

    private static class Puppy
    extends Dog<Kid> {
        private Puppy() {
        }
    }

    private static class Dog<T extends Human>
    extends Pet<T, String> {
        private T owner;

        private Dog() {
        }

        @Override
        public T owner() {
            return this.owner;
        }
    }

    private static class Kid
    extends Human {
        private Kid() {
        }
    }

    private static class Human {
        private Human() {
        }
    }

    private static abstract class Pet<T extends Human, V> {
        private Pet() {
        }

        abstract T owner();
    }
}

