/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.PercentEscaper;
import com.azure.core.http.rest.UrlEscapers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlEscaperTests {
    private static String simple = "abcABC-123";
    private static String genDelim = "abc[456#78";
    private static String safeForPath = "abc:456@78";
    private static String safeForQuery = "abc/456?78";

    @Test
    public void canEscapePathSimple() {
        PercentEscaper escaper = UrlEscapers.PATH_ESCAPER;
        String actual = escaper.escape(simple);
        Assertions.assertEquals((Object)simple, (Object)actual);
    }

    @Test
    public void canEscapeQuerySimple() {
        PercentEscaper escaper = UrlEscapers.QUERY_ESCAPER;
        String actual = escaper.escape(simple);
        Assertions.assertEquals((Object)simple, (Object)actual);
    }

    @Test
    public void canEscapePathWithGenDelim() {
        PercentEscaper escaper = UrlEscapers.PATH_ESCAPER;
        String actual = escaper.escape(genDelim);
        Assertions.assertEquals((Object)"abc%5b456%2378", (Object)actual);
    }

    @Test
    public void canEscapeQueryWithGenDelim() {
        PercentEscaper escaper = UrlEscapers.QUERY_ESCAPER;
        String actual = escaper.escape(genDelim);
        Assertions.assertEquals((Object)"abc%5b456%2378", (Object)actual);
    }

    @Test
    public void canEscapePathWithSafeForPath() {
        PercentEscaper escaper = UrlEscapers.PATH_ESCAPER;
        String actual = escaper.escape(safeForPath);
        Assertions.assertEquals((Object)safeForPath, (Object)actual);
    }

    @Test
    public void canEscapeQueryWithSafeForPath() {
        PercentEscaper escaper = UrlEscapers.QUERY_ESCAPER;
        String actual = escaper.escape(safeForPath);
        Assertions.assertEquals((Object)"abc%3a456%4078", (Object)actual);
    }

    @Test
    public void canEscapePathWithSafeForQuery() {
        PercentEscaper escaper = UrlEscapers.PATH_ESCAPER;
        String actual = escaper.escape(safeForQuery);
        Assertions.assertEquals((Object)"abc%2f456%3f78", (Object)actual);
    }

    @Test
    public void canEscapeQueryWithSafeForQuery() {
        PercentEscaper escaper = UrlEscapers.QUERY_ESCAPER;
        String actual = escaper.escape(safeForQuery);
        Assertions.assertEquals((Object)safeForQuery, (Object)actual);
    }
}

