/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.MyOtherRestException;
import com.azure.core.MyRestException;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.rest.MissingRequiredAnnotationException;
import com.azure.core.http.rest.SwaggerMethodParser;
import com.azure.core.implementation.entities.HttpBinJSON;
import java.io.IOException;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SwaggerMethodParserTests {
    @Test
    public void withNoAnnotations() {
        Assertions.assertThrows(MissingRequiredAnnotationException.class, () -> {
            Method testMethod1 = TestInterface1.class.getDeclaredMethods()[0];
            Assertions.assertEquals((Object)"testMethod1", (Object)testMethod1.getName());
            new SwaggerMethodParser(testMethod1, "https://raw.host.com");
        });
    }

    @Test
    public void withOnlyExpectedResponse() throws IOException {
        Method testMethod2 = TestInterface2.class.getDeclaredMethods()[0];
        Assertions.assertEquals((Object)"testMethod2", (Object)testMethod2.getName());
        SwaggerMethodParser methodParser = new SwaggerMethodParser(testMethod2, "https://raw.host.com");
        Assertions.assertEquals((Object)"com.azure.core.http.rest.SwaggerMethodParserTests$TestInterface2.testMethod2", (Object)methodParser.getFullyQualifiedMethodName());
        Assertions.assertEquals((Object)HttpMethod.PATCH, (Object)methodParser.getHttpMethod());
        Assertions.assertArrayEquals((int[])new int[]{200}, (int[])methodParser.getExpectedStatusCodes());
        Assertions.assertEquals(HttpResponseException.class, (Object)methodParser.getUnexpectedException(-1).getExceptionType());
        Assertions.assertEquals(Object.class, (Object)methodParser.getUnexpectedException(-1).getExceptionBodyType());
        Assertions.assertEquals((Object)false, (Object)methodParser.setHeaders(null).iterator().hasNext());
        Assertions.assertEquals((Object)"https", (Object)methodParser.setScheme(null));
        Assertions.assertEquals((Object)"raw.host.com", (Object)methodParser.setHost(null));
    }

    @Test
    public void withExpectedResponseAndUnexpectedResponseExceptionType() throws IOException {
        Method testMethod3 = TestInterface3.class.getDeclaredMethods()[0];
        Assertions.assertEquals((Object)"testMethod3", (Object)testMethod3.getName());
        SwaggerMethodParser methodParser = new SwaggerMethodParser(testMethod3, "https://raw.host.com");
        Assertions.assertEquals((Object)"com.azure.core.http.rest.SwaggerMethodParserTests$TestInterface3.testMethod3", (Object)methodParser.getFullyQualifiedMethodName());
        Assertions.assertEquals((Object)HttpMethod.PATCH, (Object)methodParser.getHttpMethod());
        Assertions.assertArrayEquals((int[])new int[]{200}, (int[])methodParser.getExpectedStatusCodes());
        Assertions.assertEquals(MyRestException.class, (Object)methodParser.getUnexpectedException(-1).getExceptionType());
        Assertions.assertEquals(HttpBinJSON.class, (Object)methodParser.getUnexpectedException(-1).getExceptionBodyType());
        Assertions.assertEquals((Object)false, (Object)methodParser.setHeaders(null).iterator().hasNext());
        Assertions.assertEquals((Object)"https", (Object)methodParser.setScheme(null));
        Assertions.assertEquals((Object)"raw.host.com", (Object)methodParser.setHost(null));
    }

    @Test
    public void withExpectedResponseAndMappedUnexpectedResponseExceptionTypeWithFallthrough() {
        Method testMethod4 = TestInterface4.class.getDeclaredMethods()[0];
        Assertions.assertEquals((Object)"testMethod4", (Object)testMethod4.getName());
        SwaggerMethodParser methodParser = new SwaggerMethodParser(testMethod4, "https://raw.host.com");
        Assertions.assertEquals((Object)"com.azure.core.http.rest.SwaggerMethodParserTests$TestInterface4.testMethod4", (Object)methodParser.getFullyQualifiedMethodName());
        Assertions.assertEquals((Object)HttpMethod.PATCH, (Object)methodParser.getHttpMethod());
        Assertions.assertArrayEquals((int[])new int[]{200}, (int[])methodParser.getExpectedStatusCodes());
        Assertions.assertEquals(HttpResponseException.class, (Object)methodParser.getUnexpectedException(400).getExceptionType());
        Assertions.assertEquals(Object.class, (Object)methodParser.getUnexpectedException(400).getExceptionBodyType());
        Assertions.assertEquals(MyRestException.class, (Object)methodParser.getUnexpectedException(-1).getExceptionType());
        Assertions.assertEquals(HttpBinJSON.class, (Object)methodParser.getUnexpectedException(-1).getExceptionBodyType());
        Assertions.assertEquals((Object)false, (Object)methodParser.setHeaders(null).iterator().hasNext());
        Assertions.assertEquals((Object)"https", (Object)methodParser.setScheme(null));
        Assertions.assertEquals((Object)"raw.host.com", (Object)methodParser.setHost(null));
    }

    @Test
    public void withExpectedResponseAndMappedUnexpectedResponseExceptionTypeWithoutFallthrough() {
        Method testMethod5 = TestInterface5.class.getDeclaredMethods()[0];
        Assertions.assertEquals((Object)"testMethod5", (Object)testMethod5.getName());
        SwaggerMethodParser methodParser = new SwaggerMethodParser(testMethod5, "https://raw.host.com");
        Assertions.assertEquals((Object)"com.azure.core.http.rest.SwaggerMethodParserTests$TestInterface5.testMethod5", (Object)methodParser.getFullyQualifiedMethodName());
        Assertions.assertEquals((Object)HttpMethod.PATCH, (Object)methodParser.getHttpMethod());
        Assertions.assertArrayEquals((int[])new int[]{200}, (int[])methodParser.getExpectedStatusCodes());
        Assertions.assertEquals(MyRestException.class, (Object)methodParser.getUnexpectedException(400).getExceptionType());
        Assertions.assertEquals(HttpBinJSON.class, (Object)methodParser.getUnexpectedException(400).getExceptionBodyType());
        Assertions.assertEquals(HttpResponseException.class, (Object)methodParser.getUnexpectedException(-1).getExceptionType());
        Assertions.assertEquals(Object.class, (Object)methodParser.getUnexpectedException(-1).getExceptionBodyType());
        Assertions.assertEquals((Object)false, (Object)methodParser.setHeaders(null).iterator().hasNext());
        Assertions.assertEquals((Object)"https", (Object)methodParser.setScheme(null));
        Assertions.assertEquals((Object)"raw.host.com", (Object)methodParser.setHost(null));
    }

    @Test
    public void withExpectedResponseAndMultipleMappedUnexpectedResponseExceptionTypes() {
        Method testMethod6 = TestInterface6.class.getDeclaredMethods()[0];
        Assertions.assertEquals((Object)"testMethod6", (Object)testMethod6.getName());
        SwaggerMethodParser methodParser = new SwaggerMethodParser(testMethod6, "https://raw.host.com");
        Assertions.assertEquals((Object)"com.azure.core.http.rest.SwaggerMethodParserTests$TestInterface6.testMethod6", (Object)methodParser.getFullyQualifiedMethodName());
        Assertions.assertEquals((Object)HttpMethod.PATCH, (Object)methodParser.getHttpMethod());
        Assertions.assertArrayEquals((int[])new int[]{200}, (int[])methodParser.getExpectedStatusCodes());
        Assertions.assertEquals(MyRestException.class, (Object)methodParser.getUnexpectedException(400).getExceptionType());
        Assertions.assertEquals(HttpBinJSON.class, (Object)methodParser.getUnexpectedException(400).getExceptionBodyType());
        Assertions.assertEquals(MyRestException.class, (Object)methodParser.getUnexpectedException(401).getExceptionType());
        Assertions.assertEquals(HttpBinJSON.class, (Object)methodParser.getUnexpectedException(401).getExceptionBodyType());
        Assertions.assertEquals(HttpResponseException.class, (Object)methodParser.getUnexpectedException(404).getExceptionType());
        Assertions.assertEquals(Object.class, (Object)methodParser.getUnexpectedException(404).getExceptionBodyType());
        Assertions.assertEquals(HttpResponseException.class, (Object)methodParser.getUnexpectedException(409).getExceptionType());
        Assertions.assertEquals(Object.class, (Object)methodParser.getUnexpectedException(409).getExceptionBodyType());
        Assertions.assertEquals(MyOtherRestException.class, (Object)methodParser.getUnexpectedException(-1).getExceptionType());
        Assertions.assertEquals(HttpBinJSON.class, (Object)methodParser.getUnexpectedException(-1).getExceptionBodyType());
        Assertions.assertEquals((Object)false, (Object)methodParser.setHeaders(null).iterator().hasNext());
        Assertions.assertEquals((Object)"https", (Object)methodParser.setScheme(null));
        Assertions.assertEquals((Object)"raw.host.com", (Object)methodParser.setHost(null));
    }

    @Test
    public void withInvalidUnexpectedResponseAnnotationsExceptionByDefaultAnnotation() {
        Method testMethod7 = TestInterface7.class.getDeclaredMethods()[0];
        Assertions.assertEquals((Object)"testMethod7", (Object)testMethod7.getName());
        SwaggerMethodParser methodParser = new SwaggerMethodParser(testMethod7, "https://raw.host.com");
        Assertions.assertEquals((Object)"com.azure.core.http.rest.SwaggerMethodParserTests$TestInterface7.testMethod7", (Object)methodParser.getFullyQualifiedMethodName());
        Assertions.assertEquals(HttpResponseException.class, (Object)methodParser.getUnexpectedException(-1).getExceptionType());
        Assertions.assertEquals(Object.class, (Object)methodParser.getUnexpectedException(-1).getExceptionBodyType());
        Assertions.assertEquals((Object)false, (Object)methodParser.setHeaders(null).iterator().hasNext());
        Assertions.assertEquals((Object)"https", (Object)methodParser.setScheme(null));
        Assertions.assertEquals((Object)"raw.host.com", (Object)methodParser.setHost(null));
    }

    @Test
    public void withInvalidUnexpectedResponseAnnotationsExceptionByRepeatCodes() {
        Method testMethod8 = TestInterface8.class.getDeclaredMethods()[0];
        Assertions.assertEquals((Object)"testMethod8", (Object)testMethod8.getName());
        SwaggerMethodParser methodParser = new SwaggerMethodParser(testMethod8, "https://raw.host.com");
        Assertions.assertEquals((Object)"com.azure.core.http.rest.SwaggerMethodParserTests$TestInterface8.testMethod8", (Object)methodParser.getFullyQualifiedMethodName());
        Assertions.assertEquals(HttpResponseException.class, (Object)methodParser.getUnexpectedException(404).getExceptionType());
        Assertions.assertEquals(Object.class, (Object)methodParser.getUnexpectedException(404).getExceptionBodyType());
        Assertions.assertEquals(HttpResponseException.class, (Object)methodParser.getUnexpectedException(-1).getExceptionType());
        Assertions.assertEquals(Object.class, (Object)methodParser.getUnexpectedException(-1).getExceptionBodyType());
        Assertions.assertEquals((Object)false, (Object)methodParser.setHeaders(null).iterator().hasNext());
        Assertions.assertEquals((Object)"https", (Object)methodParser.setScheme(null));
        Assertions.assertEquals((Object)"raw.host.com", (Object)methodParser.setHost(null));
    }

    static interface TestInterface8 {
        @Patch(value="my/rest/api/path")
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=MyRestException.class), @UnexpectedResponseExceptionType(code={404}, value=HttpResponseException.class)})
        public void testMethod8();
    }

    static interface TestInterface7 {
        @Patch(value="my/rest/api/path")
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=MyRestException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public void testMethod7();
    }

    static interface TestInterface6 {
        @Patch(value="my/rest/api/path")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400, 401}, value=MyRestException.class), @UnexpectedResponseExceptionType(code={404, 409}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=MyOtherRestException.class)})
        public void testMethod6();
    }

    static interface TestInterface5 {
        @Patch(value="my/rest/api/path")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(code={400}, value=MyRestException.class)
        public void testMethod5();
    }

    static interface TestInterface4 {
        @Patch(value="my/rest/api/path")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=MyRestException.class)})
        public void testMethod4();
    }

    static interface TestInterface3 {
        @Patch(value="my/rest/api/path")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public void testMethod3();
    }

    static interface TestInterface2 {
        @Patch(value="my/rest/api/path")
        @ExpectedResponses(value={200})
        public void testMethod2();
    }

    static interface TestInterface1 {
        public void testMethod1();
    }
}

