/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.MockHttpResponse;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.implementation.entities.AccessPolicy;
import com.azure.core.implementation.entities.SignedIdentifierInner;
import com.azure.core.implementation.entities.SignedIdentifiersWrapper;
import com.azure.core.implementation.entities.Slideshow;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RestProxyXMLTests {
    @Test
    public void canReadXMLResponse() throws Exception {
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new MockXMLHTTPClient()).build();
        MyXMLService myXMLService = (MyXMLService)RestProxy.create(MyXMLService.class, (HttpPipeline)pipeline, (SerializerAdapter)new JacksonAdapter());
        List<SignedIdentifierInner> identifiers = myXMLService.getContainerACLs().signedIdentifiers();
        Assertions.assertNotNull(identifiers);
        Assertions.assertNotEquals((int)0, (int)identifiers.size());
    }

    @Test
    public void canWriteXMLRequest() throws Exception {
        URL url = this.getClass().getClassLoader().getResource("GetContainerACLs.xml");
        byte[] bytes = Files.readAllBytes(Paths.get(url.toURI()));
        HttpRequest request = new HttpRequest(HttpMethod.PUT, new URL("http://unused/SetContainerACLs"));
        request.setBody(bytes);
        SignedIdentifierInner si = new SignedIdentifierInner();
        si.withId("MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTI=");
        AccessPolicy ap = new AccessPolicy();
        ap.withStart(OffsetDateTime.parse("2009-09-28T08:49:37.0000000Z"));
        ap.withExpiry(OffsetDateTime.parse("2009-09-29T08:49:37.0000000Z"));
        ap.withPermission("rwd");
        si.withAccessPolicy(ap);
        List<SignedIdentifierInner> expectedAcls = Collections.singletonList(si);
        JacksonAdapter serializer = new JacksonAdapter();
        MockXMLReceiverClient httpClient = new MockXMLReceiverClient();
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)httpClient).build();
        MyXMLService myXMLService = (MyXMLService)RestProxy.create(MyXMLService.class, (HttpPipeline)pipeline, (SerializerAdapter)serializer);
        SignedIdentifiersWrapper wrapper = new SignedIdentifiersWrapper(expectedAcls);
        myXMLService.setContainerACLs(wrapper);
        SignedIdentifiersWrapper actualAclsWrapped = (SignedIdentifiersWrapper)serializer.deserialize(new String(httpClient.receivedBytes, StandardCharsets.UTF_8), SignedIdentifiersWrapper.class, SerializerEncoding.XML);
        List<SignedIdentifierInner> actualAcls = actualAclsWrapped.signedIdentifiers();
        Assertions.assertEquals((int)expectedAcls.size(), (int)actualAcls.size());
        Assertions.assertEquals((Object)expectedAcls.get(0).id(), (Object)actualAcls.get(0).id());
        Assertions.assertEquals((Object)expectedAcls.get(0).accessPolicy().expiry(), (Object)actualAcls.get(0).accessPolicy().expiry());
        Assertions.assertEquals((Object)expectedAcls.get(0).accessPolicy().start(), (Object)actualAcls.get(0).accessPolicy().start());
        Assertions.assertEquals((Object)expectedAcls.get(0).accessPolicy().permission(), (Object)actualAcls.get(0).accessPolicy().permission());
    }

    @Test
    public void canDeserializeXMLWithAttributes() throws Exception {
        JacksonAdapter serializer = new JacksonAdapter();
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new MockXMLHTTPClient()).build();
        MyXMLServiceWithAttributes myXMLService = (MyXMLServiceWithAttributes)RestProxy.create(MyXMLServiceWithAttributes.class, (HttpPipeline)pipeline, (SerializerAdapter)serializer);
        Slideshow slideshow = myXMLService.getSlideshow();
        Assertions.assertEquals((Object)"Sample Slide Show", (Object)slideshow.title());
        Assertions.assertEquals((Object)"Date of publication", (Object)slideshow.date());
        Assertions.assertEquals((Object)"Yours Truly", (Object)slideshow.author());
        Assertions.assertEquals((int)2, (int)slideshow.slides().length);
        Assertions.assertEquals((Object)"all", (Object)slideshow.slides()[0].type());
        Assertions.assertEquals((Object)"Wake up to WonderWidgets!", (Object)slideshow.slides()[0].title());
        Assertions.assertEquals((int)0, (int)slideshow.slides()[0].items().length);
        Assertions.assertEquals((Object)"all", (Object)slideshow.slides()[1].type());
        Assertions.assertEquals((Object)"Overview", (Object)slideshow.slides()[1].title());
        Assertions.assertEquals((int)3, (int)slideshow.slides()[1].items().length);
        Assertions.assertEquals((Object)"Why WonderWidgets are great", (Object)slideshow.slides()[1].items()[0]);
        Assertions.assertEquals((Object)"", (Object)slideshow.slides()[1].items()[1]);
        Assertions.assertEquals((Object)"Who buys WonderWidgets", (Object)slideshow.slides()[1].items()[2]);
        String xml = serializer.serialize((Object)slideshow, SerializerEncoding.XML);
        Slideshow newSlideshow = (Slideshow)serializer.deserialize(xml, Slideshow.class, SerializerEncoding.XML);
        String newXML = serializer.serialize((Object)newSlideshow, SerializerEncoding.XML);
        Assertions.assertEquals((Object)xml, (Object)newXML);
    }

    @Host(value="http://unused")
    @ServiceInterface(name="MyXMLServiceWithAttributes")
    public static interface MyXMLServiceWithAttributes {
        @Get(value="GetXMLWithAttributes")
        public Slideshow getSlideshow();
    }

    static class MockXMLReceiverClient
    implements HttpClient {
        byte[] receivedBytes = null;

        MockXMLReceiverClient() {
        }

        public Mono<HttpResponse> send(HttpRequest request) {
            if (request.getUrl().toString().endsWith("SetContainerACLs")) {
                return FluxUtil.collectBytesInByteBufferStream((Flux)request.getBody()).map(bytes -> {
                    this.receivedBytes = bytes;
                    return new MockHttpResponse(request, 200);
                });
            }
            return Mono.just((Object)((Object)new MockHttpResponse(request, 404)));
        }
    }

    @Host(value="http://unused")
    @ServiceInterface(name="MyXMLService")
    static interface MyXMLService {
        @Get(value="GetContainerACLs")
        public SignedIdentifiersWrapper getContainerACLs();

        @Put(value="SetContainerACLs")
        public void setContainerACLs(@BodyParam(value="application/xml") SignedIdentifiersWrapper var1);
    }

    static class MockXMLHTTPClient
    implements HttpClient {
        MockXMLHTTPClient() {
        }

        private HttpResponse response(HttpRequest request, String resource) throws IOException, URISyntaxException {
            URL url = this.getClass().getClassLoader().getResource(resource);
            byte[] bytes = Files.readAllBytes(Paths.get(url.toURI()));
            HttpHeaders headers = new HttpHeaders().put("Content-Type", "application/xml");
            MockHttpResponse res = new MockHttpResponse(request, 200, headers, bytes);
            return res;
        }

        public Mono<HttpResponse> send(HttpRequest request) {
            try {
                if (request.getUrl().toString().endsWith("GetContainerACLs")) {
                    return Mono.just((Object)this.response(request, "GetContainerACLs.xml"));
                }
                if (request.getUrl().toString().endsWith("GetXMLWithAttributes")) {
                    return Mono.just((Object)this.response(request, "GetXMLWithAttributes.xml"));
                }
                return Mono.just((Object)((Object)new MockHttpResponse(request, 404)));
            }
            catch (IOException | URISyntaxException e) {
                return Mono.error((Throwable)e);
            }
        }
    }
}

