/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.IterableStream;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ResponseConstructorsCacheBenchMarkTestData {
    private static final SerializerAdapter SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();
    private static final HttpResponseDecoder RESPONSE_DECODER = new HttpResponseDecoder(SERIALIZER_ADAPTER);
    private static final HttpRequest HTTP_REQUEST = new HttpRequest(HttpMethod.GET, ResponseConstructorsCacheBenchMarkTestData.createUrl());
    private static final HttpHeaders RESPONSE_HEADERS = new HttpHeaders().put("hello", "world");
    private static final HttpHeaders RESPONSE_CUSTOM_HEADERS = new HttpHeaders().put("hello", "world").put("customHdr", "customVal");
    private static final int RESPONSE_STATUS_CODE = 200;
    private static final Foo FOO = new Foo().setName("foo1");
    private static final byte[] FOO_BYTE_ARRAY = ResponseConstructorsCacheBenchMarkTestData.asJsonByteArray(FOO);
    private static final byte[] STREAM_BYTE_ARRAY = new byte[1];
    private static final Page<Foo> PAGE_FOO = new Page<Foo>(){

        public IterableStream<Foo> getElements() {
            ArrayList<Foo> items = new ArrayList<Foo>();
            items.add(FOO);
            return new IterableStream(items);
        }

        public String getContinuationToken() {
            return null;
        }
    };
    private static final byte[] PAGE_FOO_BYTE_ARRAY = ResponseConstructorsCacheBenchMarkTestData.asJsonByteArray(PAGE_FOO);
    private static final Mono<HttpResponse> VOID_RESPONSE = Mono.just((Object)((Object)new MockResponse(HTTP_REQUEST, 200, RESPONSE_HEADERS, null)));
    private static final Mono<HttpResponse> FOO_RESPONSE = Mono.just((Object)((Object)new MockResponse(HTTP_REQUEST, 200, RESPONSE_HEADERS, FOO_BYTE_ARRAY)));
    private static final Mono<HttpResponse> STREAM_RESPONSE = Mono.just((Object)((Object)new MockResponse(HTTP_REQUEST, 200, RESPONSE_HEADERS, STREAM_BYTE_ARRAY)));
    private static final Mono<HttpResponse> FOO_PAGE_RESPONSE = Mono.just((Object)((Object)new MockResponse(HTTP_REQUEST, 200, RESPONSE_HEADERS, PAGE_FOO_BYTE_ARRAY)));
    private static final Mono<HttpResponse> FOO_CUSTOM_HEADER_RESPONSE = Mono.just((Object)((Object)new MockResponse(HTTP_REQUEST, 200, RESPONSE_CUSTOM_HEADERS, FOO_BYTE_ARRAY)));
    private final Input[] inputs = new Input[5];

    ResponseConstructorsCacheBenchMarkTestData() {
        this.inputs[0] = new Input(RESPONSE_DECODER, FooService.class, "getVoidResponse", VOID_RESPONSE, null);
        this.inputs[1] = new Input(RESPONSE_DECODER, FooService.class, "getFooSimpleResponse", FOO_RESPONSE, FOO);
        this.inputs[2] = new Input(RESPONSE_DECODER, FooService.class, "getStreamResponse", STREAM_RESPONSE, null);
        this.inputs[3] = new Input(RESPONSE_DECODER, FooService.class, "getResponseBaseFoo", FOO_CUSTOM_HEADER_RESPONSE, FOO);
        this.inputs[4] = new Input(RESPONSE_DECODER, FooService.class, "getPagedResponseBaseFoo", FOO_PAGE_RESPONSE, PAGE_FOO);
    }

    Input[] inputs() {
        return this.inputs;
    }

    private static URL createUrl() {
        try {
            return new URL("http://localhost");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] asJsonByteArray(Object object) {
        try {
            String content = SERIALIZER_ADAPTER.serialize(object, SerializerEncoding.JSON);
            return content.getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    class Input {
        private final Type returnType;
        private final HttpResponseDecoder.HttpDecodedResponse decodedResponse;
        private final Object bodyAsObject;

        Input(HttpResponseDecoder decoder, Class<?> serviceClass, String methodName, Mono<HttpResponse> httpResponse, Object bodyAsObject) {
            this.returnType = this.findMethod(serviceClass, methodName).getGenericReturnType();
            this.decodedResponse = (HttpResponseDecoder.HttpDecodedResponse)decoder.decode(httpResponse, () -> this.returnType).block();
            this.bodyAsObject = bodyAsObject;
        }

        Type returnType() {
            return this.returnType;
        }

        HttpResponseDecoder.HttpDecodedResponse decodedResponse() {
            return this.decodedResponse;
        }

        Object bodyAsObject() {
            return this.decodedResponse;
        }

        private Method findMethod(Class<?> cls, String methodName) {
            Optional<Method> optMethod = Arrays.stream(cls.getDeclaredMethods()).filter(m -> m.getName().equalsIgnoreCase(methodName)).findFirst();
            if (optMethod.isPresent()) {
                return optMethod.get();
            }
            throw new RuntimeException("Method with name '" + methodName + "' not found.");
        }
    }

    static final class MockResponse
    extends HttpResponse {
        private final int statusCode;
        private final HttpHeaders headers;
        private final Mono<byte[]> bodyBytes;
        private final Flux<ByteBuffer> bodyBb;
        private final Mono<String> bodyString;

        MockResponse(HttpRequest request, int statusCode, HttpHeaders headers, byte[] body) {
            super(request);
            this.statusCode = statusCode;
            this.headers = headers;
            this.bodyBytes = body == null ? Mono.empty() : Mono.just((Object)body);
            this.bodyBb = body == null ? Flux.empty() : Flux.just((Object)ByteBuffer.wrap(body));
            this.bodyString = body == null ? Mono.empty() : Mono.just((Object)new String(body, Charset.defaultCharset()));
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String name) {
            return this.headers.getValue(name);
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Flux<ByteBuffer> getBody() {
            return this.bodyBb;
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return this.bodyBytes;
        }

        public Mono<String> getBodyAsString() {
            return this.bodyString;
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return this.bodyString;
        }
    }

    public static interface FooService {
        public VoidResponse getVoidResponse();

        public FooSimpleResponse getFooSimpleResponse();

        public StreamResponse getStreamResponse();

        public FooResponseBase getResponseBaseFoo();

        public FooPagedResponseBase getPagedResponseBaseFoo();
    }

    static final class FooPagedResponseBase
    extends PagedResponseBase<FooHeader, Foo> {
        FooPagedResponseBase(HttpRequest request, int statusCode, HttpHeaders headers, Page<Foo> page, FooHeader decodedHeaders) {
            super(request, statusCode, headers, page, (Object)decodedHeaders);
        }
    }

    static final class FooResponseBase
    extends ResponseBase<FooHeader, Foo> {
        FooResponseBase(HttpRequest request, int statusCode, HttpHeaders headers, Foo value, FooHeader decodedHeaders) {
            super(request, statusCode, headers, (Object)value, (Object)decodedHeaders);
        }
    }

    static final class FooSimpleResponse
    extends SimpleResponse<Foo> {
        FooSimpleResponse(HttpRequest request, int statusCode, HttpHeaders headers, Foo value) {
            super(request, statusCode, headers, (Object)value);
        }
    }

    static final class VoidResponse
    extends SimpleResponse<Void> {
        VoidResponse(HttpRequest request, int statusCode, HttpHeaders headers, Void value) {
            super(request, statusCode, headers, (Object)value);
        }
    }

    static final class FooHeader {
        @JsonProperty(value="customHdr")
        private String customHdr;

        FooHeader() {
        }

        public String getCustomHdr() {
            return this.customHdr;
        }
    }

    static final class Foo {
        @JsonProperty(value="name")
        private String name;

        Foo() {
        }

        public Foo setName(String name) {
            this.name = name;
            return this;
        }

        public String getName() {
            return this.name;
        }
    }
}

