/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PagedIterableTest {
    private List<PagedResponse<Integer>> pagedResponses;
    private List<PagedResponse<String>> pagedStringResponses;
    private HttpHeaders httpHeaders = new HttpHeaders().put("header1", "value1").put("header2", "value2");
    private HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost");
    private String deserializedHeaders = "header1,value1,header2,value2";

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void streamByPage(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        List pages = pagedIterable.streamByPage().collect(Collectors.toList());
        Assertions.assertEquals((int)numberOfPages, (int)pages.size());
        Assertions.assertEquals(this.pagedResponses, pages);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void iterateByPage(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        ArrayList pages = new ArrayList();
        pagedIterable.iterableByPage().iterator().forEachRemaining(pages::add);
        Assertions.assertEquals((int)numberOfPages, (int)pages.size());
        Assertions.assertEquals(this.pagedResponses, pages);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void streamByT(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        List values = pagedIterable.stream().collect(Collectors.toList());
        Assertions.assertEquals((int)(numberOfPages * 3), (int)values.size());
        Assertions.assertEquals(Stream.iterate(0, i -> i + 1).limit(numberOfPages * 3).collect(Collectors.toList()), values);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void iterateByT(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        ArrayList values = new ArrayList();
        pagedIterable.iterator().forEachRemaining(values::add);
        Assertions.assertEquals((int)(numberOfPages * 3), (int)values.size());
        Assertions.assertEquals(Stream.iterate(0, i -> i + 1).limit(numberOfPages * 3).collect(Collectors.toList()), values);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void streamByPageMap(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        List pages = pagedIterable.mapPage(String::valueOf).streamByPage().collect(Collectors.toList());
        Assertions.assertEquals((int)numberOfPages, (int)pages.size());
        for (int i = 0; i < numberOfPages; ++i) {
            Assertions.assertEquals((Object)this.pagedStringResponses.get(i).getValue(), (Object)((PagedResponse)pages.get(i)).getValue());
        }
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void iterateByPageMap(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        ArrayList pages = new ArrayList();
        pagedIterable.mapPage(String::valueOf).iterableByPage().iterator().forEachRemaining(pages::add);
        Assertions.assertEquals((int)numberOfPages, (int)pages.size());
        for (int i = 0; i < numberOfPages; ++i) {
            Assertions.assertEquals((Object)this.pagedStringResponses.get(i).getValue(), (Object)((PagedResponse)pages.get(i)).getValue());
        }
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void streamByTMap(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        List values = pagedIterable.mapPage(String::valueOf).stream().collect(Collectors.toList());
        Assertions.assertEquals((int)(numberOfPages * 3), (int)values.size());
        Assertions.assertEquals(Stream.iterate(0, i -> i + 1).limit(numberOfPages * 3).map(String::valueOf).collect(Collectors.toList()), values);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void iterateByTMap(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        ArrayList values = new ArrayList();
        pagedIterable.mapPage(String::valueOf).iterator().forEachRemaining(values::add);
        Assertions.assertEquals((int)(numberOfPages * 3), (int)values.size());
        Assertions.assertEquals(Stream.iterate(0, i -> i + 1).limit(numberOfPages * 3).map(String::valueOf).collect(Collectors.toList()), values);
    }

    @Test
    public void streamFirstPage() {
        TestPagedFlux<Integer> pagedFlux = this.getTestPagedFlux(5);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        Assertions.assertEquals(this.pagedResponses.get(0), pagedIterable.streamByPage().limit(1L).collect(Collectors.toList()).get(0));
        Assertions.assertEquals((int)0, (int)pagedFlux.getNextPageRetrievals());
    }

    @Test
    public void iterateFirstPage() {
        TestPagedFlux<Integer> pagedFlux = this.getTestPagedFlux(5);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        Assertions.assertEquals(this.pagedResponses.get(0), pagedIterable.iterableByPage().iterator().next());
        Assertions.assertEquals((int)0, (int)pagedFlux.getNextPageRetrievals());
    }

    @Test
    public void streamFirstValue() {
        TestPagedFlux<Integer> pagedFlux = this.getTestPagedFlux(5);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        Integer firstValue = (Integer)this.pagedResponses.get(0).getValue().get(0);
        Assertions.assertEquals((Integer)firstValue, (Integer)((Integer)pagedIterable.stream().limit(1L).collect(Collectors.toList()).get(0)));
    }

    @Test
    public void iterateFirstValue() {
        TestPagedFlux<Integer> pagedFlux = this.getTestPagedFlux(5);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        Integer firstValue = (Integer)this.pagedResponses.get(0).getValue().get(0);
        Assertions.assertEquals((Integer)firstValue, (Integer)((Integer)pagedIterable.iterator().next()));
        Assertions.assertEquals((int)0, (int)pagedFlux.getNextPageRetrievals());
    }

    private PagedFlux<Integer> getIntegerPagedFlux(int numberOfPages) {
        this.createPagedResponse(numberOfPages);
        return new PagedFlux(() -> this.pagedResponses.isEmpty() ? Mono.empty() : Mono.just(this.pagedResponses.get(0)), continuationToken -> this.getNextPage((String)continuationToken, this.pagedResponses));
    }

    private TestPagedFlux<Integer> getTestPagedFlux(int numberOfPages) {
        this.createPagedResponse(numberOfPages);
        return new TestPagedFlux<Integer>(() -> this.pagedResponses.isEmpty() ? Mono.empty() : Mono.just(this.pagedResponses.get(0)), continuationToken -> this.getNextPage((String)continuationToken, this.pagedResponses));
    }

    private void createPagedResponse(int numberOfPages) {
        this.pagedResponses = IntStream.range(0, numberOfPages).boxed().map(i -> this.createPagedResponse(this.httpRequest, this.httpHeaders, this.deserializedHeaders, numberOfPages, this::getItems, (int)i)).collect(Collectors.toList());
        this.pagedStringResponses = IntStream.range(0, numberOfPages).boxed().map(i -> this.createPagedResponse(this.httpRequest, this.httpHeaders, this.deserializedHeaders, numberOfPages, this::getStringItems, (int)i)).collect(Collectors.toList());
    }

    private <T> PagedResponseBase<String, T> createPagedResponse(HttpRequest httpRequest, HttpHeaders headers, String deserializedHeaders, int numberOfPages, Function<Integer, List<T>> valueSupplier, int i) {
        return new PagedResponseBase(httpRequest, 200, headers, valueSupplier.apply(i), i < numberOfPages - 1 ? String.valueOf(i + 1) : null, (Object)deserializedHeaders);
    }

    private Mono<PagedResponse<Integer>> getNextPage(String continuationToken, List<PagedResponse<Integer>> pagedResponses) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        return Mono.just(pagedResponses.get(Integer.parseInt(continuationToken)));
    }

    private List<Integer> getItems(int i) {
        return IntStream.range(i * 3, i * 3 + 3).boxed().collect(Collectors.toList());
    }

    private List<String> getStringItems(int i) {
        return IntStream.range(i * 3, i * 3 + 3).boxed().map(String::valueOf).collect(Collectors.toList());
    }

    private static class TestPagedFlux<T>
    extends PagedFlux<T> {
        private int nextPageRetrievals = 0;

        TestPagedFlux(Supplier<Mono<PagedResponse<T>>> firstPageRetriever, Function<String, Mono<PagedResponse<T>>> nextPageRetriever) {
            super(firstPageRetriever, nextPageRetriever);
        }

        public Flux<PagedResponse<T>> byPage(String continuationToken) {
            ++this.nextPageRetrievals;
            return super.byPage(continuationToken);
        }

        int getNextPageRetrievals() {
            return this.nextPageRetrievals;
        }
    }
}

