/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.PagedFluxBase;
import com.azure.core.http.rest.PagedResponse;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Mono;

public final class PagedFluxBaseJavaDocCodeSnippets {
    public void classDocSnippet() {
        PagedFluxBase<Integer, PagedResponse<Integer>> pagedFluxBase = this.createAnInstance();
        pagedFluxBase.log().subscribe(item -> System.out.println("Processing item " + item), error -> System.err.println("Error occurred " + error), () -> System.out.println("Completed processing."));
        pagedFluxBase.byPage().log().subscribe(page -> System.out.println("Processing page containing " + page.getItems()), error -> System.err.println("Error occurred " + error), () -> System.out.println("Completed processing."));
        String continuationToken = this.getContinuationToken();
        pagedFluxBase.byPage(continuationToken).log().doOnSubscribe(ignored -> System.out.println("Subscribed to paged flux processing pages starting from: " + continuationToken)).subscribe(page -> System.out.println("Processing page containing " + page.getItems()), error -> System.err.println("Error occurred " + error), () -> System.out.println("Completed processing."));
    }

    private PagedFluxBase<Integer, PagedResponse<Integer>> createAnInstance() {
        Supplier<Mono> firstPageRetriever = () -> this.getFirstPage();
        Function<String, Mono> nextPageRetriever = continuationToken -> this.getNextPage((String)continuationToken);
        PagedFluxBase pagedFluxBase = new PagedFluxBase(firstPageRetriever, nextPageRetriever);
        Supplier<Mono> firstPageRetrieverFunction = () -> this.getFirstPage();
        PagedFluxBase pagedFluxBaseInstance = new PagedFluxBase(firstPageRetrieverFunction, nextPageRetriever);
        return pagedFluxBase;
    }

    public void byPageSnippet() {
        PagedFluxBase<Integer, PagedResponse<Integer>> pagedFluxBase = this.createAnInstance();
        pagedFluxBase.byPage().log().doOnSubscribe(ignoredVal -> System.out.println("Subscribed to paged flux processing pages starting from first page")).subscribe(page -> System.out.println("Processing page containing " + page.getItems()), error -> System.err.println("Error occurred " + error), () -> System.out.println("Completed processing."));
        String continuationToken = this.getContinuationToken();
        pagedFluxBase.byPage(continuationToken).log().doOnSubscribe(ignoredVal -> System.out.println("Subscribed to paged flux processing page starting from " + continuationToken)).subscribe(page -> System.out.println("Processing page containing " + page.getItems()), error -> System.err.println("Error occurred " + error), () -> System.out.println("Completed processing."));
    }

    public void byTSnippet() {
        PagedFluxBase<Integer, PagedResponse<Integer>> pagedFluxBase = this.createAnInstance();
        pagedFluxBase.subscribe((CoreSubscriber)new BaseSubscriber<Integer>(){

            protected void hookOnSubscribe(Subscription subscription) {
                System.out.println("Subscribed to paged flux processing items");
                super.hookOnSubscribe(subscription);
            }

            protected void hookOnNext(Integer value) {
                System.out.println("Processing item " + value);
            }

            protected void hookOnComplete() {
                System.out.println("Completed processing");
            }
        });
    }

    private String getContinuationToken() {
        return null;
    }

    private Mono<PagedResponse<Integer>> getNextPage(String continuationToken) {
        return null;
    }

    private Mono<PagedResponse<Integer>> getFirstPage() {
        return null;
    }
}

