/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.MockHttpResponse;
import com.azure.core.http.clients.NoOpHttpClient;
import com.azure.core.http.policy.ExponentialBackoff;
import com.azure.core.http.policy.FixedDelay;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;

public class RetryPolicyTests {
    @Test
    public void retryEndOn501() throws Exception {
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient(){
            private final int[] codes = new int[]{408, 500, 502, 501};
            private int count = 0;

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                return Mono.just((Object)((Object)new MockHttpResponse(request, this.codes[this.count++])));
            }
        }).policies(new HttpPipelinePolicy[]{new RetryPolicy((RetryStrategy)new FixedDelay(3, Duration.of(0L, ChronoUnit.MILLIS)))}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)501, (int)response.getStatusCode());
    }

    @Test
    public void retryMax() throws Exception {
        int maxRetries = 5;
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient(){
            int count = -1;

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                Assertions.assertTrue((this.count++ < 5 ? 1 : 0) != 0);
                return Mono.just((Object)((Object)new MockHttpResponse(request, 500)));
            }
        }).policies(new HttpPipelinePolicy[]{new RetryPolicy((RetryStrategy)new FixedDelay(5, Duration.of(0L, ChronoUnit.MILLIS)))}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)500, (int)response.getStatusCode());
    }

    @Test
    public void fixedDelayRetry() throws Exception {
        int maxRetries = 5;
        long delayMillis = 500L;
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient(){
            int count = -1;
            long previousAttemptMadeAt = -1L;

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                if (this.count > 0) {
                    Assertions.assertTrue((System.currentTimeMillis() >= this.previousAttemptMadeAt + 500L ? 1 : 0) != 0);
                }
                Assertions.assertTrue((this.count++ < 5 ? 1 : 0) != 0);
                this.previousAttemptMadeAt = System.currentTimeMillis();
                return Mono.just((Object)((Object)new MockHttpResponse(request, 500)));
            }
        }).policies(new HttpPipelinePolicy[]{new RetryPolicy((RetryStrategy)new FixedDelay(5, Duration.ofMillis(500L)))}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
    }

    @Test
    public void exponentialDelayRetry() throws Exception {
        int maxRetries = 5;
        long baseDelayMillis = 1000L;
        long maxDelayMillis = 100000L;
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(5, Duration.ofMillis(1000L), Duration.ofMillis(100000L));
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient(){
            int count = -1;
            long previousAttemptMadeAt = -1L;

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                if (this.count > 0) {
                    long expectedToBeMadeAt;
                    long requestMadeAt = System.currentTimeMillis();
                    Assertions.assertTrue((requestMadeAt >= (expectedToBeMadeAt = this.previousAttemptMadeAt + (long)(1 << this.count - 1) * 950L) ? 1 : 0) != 0);
                }
                Assertions.assertTrue((this.count++ < 5 ? 1 : 0) != 0);
                this.previousAttemptMadeAt = System.currentTimeMillis();
                return Mono.just((Object)((Object)new MockHttpResponse(request, 503)));
            }
        }).policies(new HttpPipelinePolicy[]{new RetryPolicy((RetryStrategy)exponentialBackoff)}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
    }
}

