/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.clients.NoOpHttpClient;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.ProtocolPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProtocolPolicyTests {
    @Test
    public void withOverwrite() throws MalformedURLException {
        HttpPipeline pipeline = ProtocolPolicyTests.createPipeline("ftp", "ftp://www.bing.com");
        pipeline.send(ProtocolPolicyTests.createHttpRequest("http://www.bing.com"));
    }

    @Test
    public void withNoOverwrite() throws MalformedURLException {
        HttpPipeline pipeline = ProtocolPolicyTests.createPipeline("ftp", false, "https://www.bing.com");
        pipeline.send(ProtocolPolicyTests.createHttpRequest("https://www.bing.com"));
    }

    private static HttpPipeline createPipeline(String protocol, String expectedUrl) {
        return new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{new ProtocolPolicy(protocol, true), (context, next) -> {
            Assertions.assertEquals((Object)expectedUrl, (Object)context.getHttpRequest().getUrl().toString());
            return next.process();
        }}).build();
    }

    private static HttpPipeline createPipeline(String protocol, boolean overwrite, String expectedUrl) {
        return new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{new ProtocolPolicy(protocol, overwrite), (context, next) -> {
            Assertions.assertEquals((Object)expectedUrl, (Object)context.getHttpRequest().getUrl().toString());
            return next.process();
        }}).build();
    }

    private static HttpRequest createHttpRequest(String url) throws MalformedURLException {
        return new HttpRequest(HttpMethod.GET, new URL(url));
    }
}

