/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.policy.FixedDelay;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FixedDelayTest {
    @Test
    public void testNullDelay() {
        Assertions.assertThrows(NullPointerException.class, () -> new FixedDelay(3, null));
    }

    @Test
    public void testNegativeMaxRetries() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FixedDelay(-1, Duration.ofSeconds(1L)));
    }

    @Test
    public void testZeroDelay() {
        FixedDelay fixedDelay = new FixedDelay(3, Duration.ofSeconds(0L));
        Assertions.assertEquals((int)fixedDelay.getMaxRetries(), (int)3);
        Assertions.assertEquals((long)fixedDelay.calculateRetryDelay(2).toMillis(), (long)0L);
    }

    @Test
    public void testFixedDelay() {
        FixedDelay fixedDelay = new FixedDelay(3, Duration.ofSeconds(1L));
        Assertions.assertEquals((int)fixedDelay.getMaxRetries(), (int)3);
        Assertions.assertEquals((long)fixedDelay.calculateRetryDelay(2).toMillis(), (long)1000L);
    }
}

