/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.policy.ExponentialBackoff;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExponentialBackoffTest {
    @Test
    public void testZeroBaseDelay() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ExponentialBackoff(3, Duration.ofSeconds(0L), Duration.ofMillis(1000L)));
    }

    @Test
    public void testNullBaseDelay() {
        Assertions.assertThrows(NullPointerException.class, () -> new ExponentialBackoff(3, null, Duration.ofMillis(1000L)));
    }

    @Test
    public void testNullMaxDelay() {
        Assertions.assertThrows(NullPointerException.class, () -> new ExponentialBackoff(3, Duration.ofSeconds(1L), null));
    }

    @Test
    public void testBaseGreaterThanMaxDelay() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ExponentialBackoff(3, Duration.ofSeconds(1L), Duration.ofMillis(500L)));
    }

    @Test
    public void testNegativeMaxRetries() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ExponentialBackoff(-1, Duration.ofSeconds(1L), Duration.ofMillis(5000L)));
    }

    @Test
    public void testBaseEqualToMaxDelay() {
        ExponentialBackoff expBackoff = new ExponentialBackoff(3, Duration.ofSeconds(1L), Duration.ofMillis(1000L));
        Assertions.assertEquals((int)expBackoff.getMaxRetries(), (int)3);
        Assertions.assertTrue((expBackoff.calculateRetryDelay(0).toMillis() <= 1000L ? 1 : 0) != 0);
        Assertions.assertTrue((expBackoff.calculateRetryDelay(1).toMillis() == 1000L ? 1 : 0) != 0);
        Assertions.assertTrue((expBackoff.calculateRetryDelay(2).toMillis() == 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultExponentialBackoff() {
        ExponentialBackoff expBackoff = new ExponentialBackoff();
        Assertions.assertEquals((int)3, (int)expBackoff.getMaxRetries());
        for (int i = 0; i < 3; ++i) {
            long delayMillis = expBackoff.calculateRetryDelay(i).toMillis();
            Assertions.assertTrue(((double)delayMillis >= (double)(1 << i) * 760.0 && (double)delayMillis <= (double)(1 << i) * 840.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExponentialBackoff() {
        int i;
        ExponentialBackoff expBackoff = new ExponentialBackoff(10, Duration.ofSeconds(1L), Duration.ofSeconds(10L));
        for (i = 0; i < 4; ++i) {
            long delayMillis = expBackoff.calculateRetryDelay(i).toMillis();
            Assertions.assertTrue((delayMillis >= (long)((1 << i) * 950) && delayMillis <= (long)((1 << i) * 1050) ? 1 : 0) != 0);
        }
        for (i = 4; i < 10; ++i) {
            Assertions.assertEquals((long)expBackoff.calculateRetryDelay(i).toMillis(), (long)10000L);
        }
    }
}

