/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.ProxyOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ProxyOptionsTests {
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final String PROXY_HOST = "localhost";
    private static final String PROXY_USER = "user";
    private static final String PROXY_PASSWORD = "pass";
    private static final String NON_PROXY_HOSTS = "notlocalhost";
    private static final String JAVA_PROXY_PREREQUISITE = "java.net.useSystemProxies";
    private static final String JAVA_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String JAVA_HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String JAVA_HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String JAVA_HTTPS_PROXY_USER = "https.proxyUser";
    private static final String JAVA_HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    private static final String JAVA_HTTP_PROXY_HOST = "http.proxyHost";
    private static final String JAVA_HTTP_PROXY_PORT = "http.proxyPort";
    private static final String JAVA_HTTP_PROXY_USER = "http.proxyUser";
    private static final String JAVA_HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String AZURE_HTTPS_PROXY_HOST_ONLY = String.format("%s://%s", "https", "localhost");
    private static final String AZURE_HTTP_PROXY_HOST_ONLY = String.format("%s://%s", "http", "localhost");
    private static final String AZURE_HTTPS_PROXY_WITH_USERNAME = String.format("%s://%s@%s", "https", "user", "localhost");
    private static final String AZURE_HTTP_PROXY_WITH_USERNAME = String.format("%s://%s@%s", "http", "user", "localhost");
    private static final String AZURE_HTTPS_PROXY_WITH_USER_AND_PASS = String.format("%s://%s:%s@%s", "https", "user", "pass", "localhost");
    private static final String AZURE_HTTP_PROXY_WITH_USER_AND_PASS = String.format("%s://%s:%s@%s", "http", "user", "pass", "localhost");

    @ParameterizedTest
    @MethodSource(value={"loadFromEnvironmentSupplier"})
    public void loadFromEnvironment(Configuration configuration, String expectedHost, int expectedPort, String expectedUsername, String expectedPassword, String expectedNonProxyHosts) {
        ProxyOptions proxyOptions = ProxyOptions.fromConfiguration((Configuration)configuration);
        Assertions.assertNotNull((Object)proxyOptions);
        Assertions.assertEquals((Object)expectedHost, (Object)proxyOptions.getAddress().getHostName());
        Assertions.assertEquals((int)expectedPort, (int)proxyOptions.getAddress().getPort());
        Assertions.assertEquals((Object)expectedUsername, (Object)proxyOptions.getUsername());
        Assertions.assertEquals((Object)expectedPassword, (Object)proxyOptions.getPassword());
        Assertions.assertEquals((Object)expectedNonProxyHosts, (Object)proxyOptions.getNonProxyHosts());
    }

    private static Stream<Arguments> loadFromEnvironmentSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{new Configuration().put("HTTPS_PROXY", AZURE_HTTPS_PROXY_HOST_ONLY), PROXY_HOST, 443, null, null, null}), Arguments.of((Object[])new Object[]{new Configuration().put("HTTPS_PROXY", AZURE_HTTPS_PROXY_WITH_USERNAME), PROXY_HOST, 443, null, null, null}), Arguments.of((Object[])new Object[]{new Configuration().put("HTTPS_PROXY", AZURE_HTTPS_PROXY_WITH_USER_AND_PASS), PROXY_HOST, 443, PROXY_USER, PROXY_PASSWORD, null}), Arguments.of((Object[])new Object[]{new Configuration().put("HTTPS_PROXY", AZURE_HTTPS_PROXY_HOST_ONLY).put("NO_PROXY", NON_PROXY_HOSTS), PROXY_HOST, 443, null, null, NON_PROXY_HOSTS}), Arguments.of((Object[])new Object[]{new Configuration().put("HTTP_PROXY", AZURE_HTTP_PROXY_HOST_ONLY), PROXY_HOST, 80, null, null, null}), Arguments.of((Object[])new Object[]{new Configuration().put("HTTP_PROXY", AZURE_HTTP_PROXY_WITH_USERNAME), PROXY_HOST, 80, null, null, null}), Arguments.of((Object[])new Object[]{new Configuration().put("HTTP_PROXY", AZURE_HTTP_PROXY_WITH_USER_AND_PASS), PROXY_HOST, 80, PROXY_USER, PROXY_PASSWORD, null}), Arguments.of((Object[])new Object[]{new Configuration().put("HTTP_PROXY", AZURE_HTTP_PROXY_HOST_ONLY).put("NO_PROXY", NON_PROXY_HOSTS), PROXY_HOST, 80, null, null, NON_PROXY_HOSTS}), Arguments.of((Object[])new Object[]{ProxyOptionsTests.createJavaConfiguration(443, null, null, null, true, true), PROXY_HOST, 443, null, null, ProxyOptionsTests.getJavaNonProxyHosts()}), Arguments.of((Object[])new Object[]{ProxyOptionsTests.createJavaConfiguration(443, PROXY_USER, null, null, true, true), PROXY_HOST, 443, null, null, ProxyOptionsTests.getJavaNonProxyHosts()}), Arguments.of((Object[])new Object[]{ProxyOptionsTests.createJavaConfiguration(443, PROXY_USER, PROXY_PASSWORD, null, true, true), PROXY_HOST, 443, PROXY_USER, PROXY_PASSWORD, ProxyOptionsTests.getJavaNonProxyHosts()}), Arguments.of((Object[])new Object[]{ProxyOptionsTests.createJavaConfiguration(443, null, null, NON_PROXY_HOSTS, true, true), PROXY_HOST, 443, null, null, NON_PROXY_HOSTS}), Arguments.of((Object[])new Object[]{ProxyOptionsTests.createJavaConfiguration(80, null, null, null, false, true), PROXY_HOST, 80, null, null, ProxyOptionsTests.getJavaNonProxyHosts()}), Arguments.of((Object[])new Object[]{ProxyOptionsTests.createJavaConfiguration(80, PROXY_USER, null, null, false, true), PROXY_HOST, 80, null, null, ProxyOptionsTests.getJavaNonProxyHosts()}), Arguments.of((Object[])new Object[]{ProxyOptionsTests.createJavaConfiguration(80, PROXY_USER, PROXY_PASSWORD, null, false, true), PROXY_HOST, 80, PROXY_USER, PROXY_PASSWORD, ProxyOptionsTests.getJavaNonProxyHosts()}), Arguments.of((Object[])new Object[]{ProxyOptionsTests.createJavaConfiguration(80, null, null, NON_PROXY_HOSTS, false, true), PROXY_HOST, 80, null, null, NON_PROXY_HOSTS}));
    }

    @Test
    public void loadFromEnvironmentThrowsWhenPassedConfigurationNone() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ProxyOptions.fromConfiguration((Configuration)Configuration.NONE));
    }

    @ParameterizedTest
    @MethodSource(value={"javaProxiesRequireUseSystemProxiesSupplier"})
    public void javaProxiesRequireUseSystemProxies(Configuration configuration) {
        Assertions.assertNull((Object)ProxyOptions.fromConfiguration((Configuration)configuration));
    }

    private static Stream<Arguments> javaProxiesRequireUseSystemProxiesSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{ProxyOptionsTests.createJavaConfiguration(443, null, null, null, true, false)}), Arguments.of((Object[])new Object[]{ProxyOptionsTests.createJavaConfiguration(80, null, null, null, false, false)}));
    }

    private static Configuration createJavaConfiguration(int port, String username, String password, String nonProxyHosts, boolean isHttps, boolean enabled) {
        Configuration configuration = new Configuration().put(JAVA_PROXY_PREREQUISITE, String.valueOf(enabled));
        ProxyOptionsTests.putIfNotNull(configuration, JAVA_NON_PROXY_HOSTS, nonProxyHosts);
        if (isHttps) {
            configuration.put(JAVA_HTTPS_PROXY_HOST, PROXY_HOST).put(JAVA_HTTPS_PROXY_PORT, String.valueOf(port));
            configuration = ProxyOptionsTests.putIfNotNull(configuration, JAVA_HTTPS_PROXY_USER, username);
            configuration = ProxyOptionsTests.putIfNotNull(configuration, JAVA_HTTPS_PROXY_PASSWORD, password);
        } else {
            configuration.put(JAVA_HTTP_PROXY_HOST, PROXY_HOST).put(JAVA_HTTP_PROXY_PORT, String.valueOf(port));
            configuration = ProxyOptionsTests.putIfNotNull(configuration, JAVA_HTTP_PROXY_USER, username);
            configuration = ProxyOptionsTests.putIfNotNull(configuration, JAVA_HTTP_PROXY_PASSWORD, password);
        }
        return configuration;
    }

    private static Configuration putIfNotNull(Configuration configuration, String name, String value) {
        if (value == null) {
            value = Configuration.getGlobalConfiguration().get(name);
        }
        return CoreUtils.isNullOrEmpty((CharSequence)value) ? configuration : configuration.put(name, value);
    }

    private static String getJavaNonProxyHosts() {
        return Configuration.getGlobalConfiguration().get(JAVA_NON_PROXY_HOSTS);
    }
}

