/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockHttpResponse
extends HttpResponse {
    private static final SerializerAdapter SERIALIZER = new JacksonAdapter();
    private final int statusCode;
    private final HttpHeaders headers;
    private final byte[] bodyBytes;

    public MockHttpResponse(HttpRequest request, int statusCode, HttpHeaders headers, byte[] bodyBytes) {
        super(request);
        this.statusCode = statusCode;
        this.headers = headers;
        this.bodyBytes = bodyBytes;
    }

    public MockHttpResponse(HttpRequest request, int statusCode) {
        this(request, statusCode, new HttpHeaders(), new byte[0]);
    }

    public MockHttpResponse(HttpRequest request, int statusCode, HttpHeaders headers) {
        this(request, statusCode, headers, new byte[0]);
    }

    public MockHttpResponse(HttpRequest request, int statusCode, HttpHeaders headers, Object serializable) {
        this(request, statusCode, headers, MockHttpResponse.serialize(serializable));
    }

    public MockHttpResponse(HttpRequest request, int statusCode, Object serializable) {
        this(request, statusCode, new HttpHeaders(), MockHttpResponse.serialize(serializable));
    }

    private static byte[] serialize(Object serializable) {
        byte[] result = null;
        try {
            String serializedString = SERIALIZER.serialize(serializable, SerializerEncoding.JSON);
            result = serializedString == null ? null : serializedString.getBytes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    public HttpHeaders getHeaders() {
        return new HttpHeaders((Iterable)this.headers);
    }

    public Mono<byte[]> getBodyAsByteArray() {
        if (this.bodyBytes == null) {
            return Mono.empty();
        }
        return Mono.just((Object)this.bodyBytes);
    }

    public Flux<ByteBuffer> getBody() {
        if (this.bodyBytes == null) {
            return Flux.empty();
        }
        return Flux.just((Object)ByteBuffer.wrap(this.bodyBytes));
    }

    public Mono<String> getBodyAsString() {
        if (this.bodyBytes == null) {
            return Mono.empty();
        }
        return Mono.just((Object)new String(this.bodyBytes, StandardCharsets.UTF_8));
    }

    public Mono<String> getBodyAsString(Charset charset) {
        if (this.bodyBytes == null) {
            return Mono.empty();
        }
        return Mono.just((Object)new String(this.bodyBytes, charset));
    }
}

