/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;

public class HttpRequestTests {
    @Test
    public void constructor() throws MalformedURLException {
        HttpRequest request = new HttpRequest(HttpMethod.POST, new URL("http://request.url"));
        Assertions.assertEquals((Object)HttpMethod.POST, (Object)request.getHttpMethod());
        Assertions.assertEquals((Object)new URL("http://request.url"), (Object)request.getUrl());
    }

    @Test
    public void testClone() throws IOException {
        HttpHeaders headers = new HttpHeaders().put("my-header", "my-value").put("other-header", "other-value");
        HttpRequest request = new HttpRequest(HttpMethod.PUT, new URL("http://request.url"), headers, Flux.empty());
        HttpRequest bufferedRequest = request.copy();
        Assertions.assertNotSame((Object)request, (Object)bufferedRequest);
        Assertions.assertEquals((Object)request.getHttpMethod(), (Object)bufferedRequest.getHttpMethod());
        Assertions.assertEquals((Object)request.getUrl(), (Object)bufferedRequest.getUrl());
        Assertions.assertNotSame((Object)request.getHeaders(), (Object)bufferedRequest.getHeaders());
        Assertions.assertEquals((int)request.getHeaders().getSize(), (int)bufferedRequest.getHeaders().getSize());
        for (HttpHeader clonedHeader : bufferedRequest.getHeaders()) {
            for (HttpHeader originalHeader : request.getHeaders()) {
                Assertions.assertNotSame((Object)clonedHeader, (Object)originalHeader);
            }
            Assertions.assertEquals((Object)clonedHeader.getValue(), (Object)request.getHeaders().getValue(clonedHeader.getName()));
        }
        Assertions.assertSame((Object)request.getBody(), (Object)bufferedRequest.getBody());
    }
}

