/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.MockHttpResponse;
import com.azure.core.http.clients.NoOpHttpClient;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.PortPolicy;
import com.azure.core.http.policy.ProtocolPolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;

public class HttpPipelineTests {
    @Test
    public void constructorWithNoArguments() {
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                return null;
            }
        }).build();
        Assertions.assertEquals((int)0, (int)pipeline.getPolicyCount());
        Assertions.assertNotNull((Object)pipeline.getHttpClient());
    }

    @Test
    public void withRequestPolicy() {
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new PortPolicy(80, true), new ProtocolPolicy("ftp", true), new RetryPolicy()}).httpClient((HttpClient)new NoOpHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                return null;
            }
        }).build();
        Assertions.assertEquals((int)3, (int)pipeline.getPolicyCount());
        Assertions.assertEquals(PortPolicy.class, pipeline.getPolicy(0).getClass());
        Assertions.assertEquals(ProtocolPolicy.class, pipeline.getPolicy(1).getClass());
        Assertions.assertEquals(RetryPolicy.class, pipeline.getPolicy(2).getClass());
        Assertions.assertNotNull((Object)pipeline.getHttpClient());
    }

    @Test
    public void withRequestOptions() throws MalformedURLException {
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new PortPolicy(80, true), new ProtocolPolicy("ftp", true), new RetryPolicy()}).httpClient((HttpClient)new NoOpHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                return null;
            }
        }).build();
        HttpPipelineCallContext context = new HttpPipelineCallContext(new HttpRequest(HttpMethod.GET, new URL("http://foo.com")));
        Assertions.assertNotNull((Object)context);
        Assertions.assertNotNull((Object)pipeline.getHttpClient());
    }

    @Test
    public void withNoRequestPolicies() throws MalformedURLException {
        final HttpMethod expectedHttpMethod = HttpMethod.GET;
        final URL expectedUrl = new URL("http://my.site.com");
        HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                Assertions.assertEquals((int)0, (int)request.getHeaders().getSize());
                Assertions.assertEquals((Object)expectedHttpMethod, (Object)request.getHttpMethod());
                Assertions.assertEquals((Object)expectedUrl, (Object)request.getUrl());
                return Mono.just((Object)((Object)new MockHttpResponse(request, 200)));
            }
        }).build();
        HttpResponse response = (HttpResponse)httpPipeline.send(new HttpRequest(expectedHttpMethod, expectedUrl)).block();
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
    }

    @Test
    public void withUserAgentRequestPolicy() throws MalformedURLException {
        final HttpMethod expectedHttpMethod = HttpMethod.GET;
        final URL expectedUrl = new URL("http://my.site.com/1");
        String expectedUserAgent = "my-user-agent";
        NoOpHttpClient httpClient = new NoOpHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                Assertions.assertEquals((int)1, (int)request.getHeaders().getSize());
                Assertions.assertEquals((Object)"my-user-agent", (Object)request.getHeaders().getValue("User-Agent"));
                Assertions.assertEquals((Object)expectedHttpMethod, (Object)request.getHttpMethod());
                Assertions.assertEquals((Object)expectedUrl, (Object)request.getUrl());
                return Mono.just((Object)((Object)new MockHttpResponse(request, 200)));
            }
        };
        HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient((HttpClient)httpClient).policies(new HttpPipelinePolicy[]{new UserAgentPolicy("my-user-agent")}).build();
        HttpResponse response = (HttpResponse)httpPipeline.send(new HttpRequest(expectedHttpMethod, expectedUrl)).block();
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
    }

    @Test
    public void withRequestIdRequestPolicy() throws MalformedURLException {
        final HttpMethod expectedHttpMethod = HttpMethod.GET;
        final URL expectedUrl = new URL("http://my.site.com/1");
        HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                Assertions.assertEquals((int)1, (int)request.getHeaders().getSize());
                String requestId = request.getHeaders().getValue("x-ms-client-request-id");
                Assertions.assertNotNull((Object)requestId);
                Assertions.assertFalse((boolean)requestId.isEmpty());
                Assertions.assertEquals((Object)expectedHttpMethod, (Object)request.getHttpMethod());
                Assertions.assertEquals((Object)expectedUrl, (Object)request.getUrl());
                return Mono.just((Object)((Object)new MockHttpResponse(request, 200)));
            }
        }).policies(new HttpPipelinePolicy[]{new RequestIdPolicy()}).build();
        HttpResponse response = (HttpResponse)httpPipeline.send(new HttpRequest(expectedHttpMethod, expectedUrl)).block();
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
    }
}

