/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpHeaders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpHeadersTests {
    @Test
    public void testSet() {
        HttpHeaders headers = new HttpHeaders();
        headers.put("a", "b");
        Assertions.assertEquals((Object)"b", (Object)headers.getValue("a"));
        headers.put("a", "c");
        Assertions.assertEquals((Object)"c", (Object)headers.getValue("a"));
        headers.put("a", null);
        Assertions.assertNull((Object)headers.getValue("a"));
        headers.put("A", "");
        Assertions.assertEquals((Object)"", (Object)headers.getValue("a"));
        headers.put("A", "b");
        Assertions.assertEquals((Object)"b", (Object)headers.getValue("A"));
        headers.put("a", null);
        Assertions.assertNull((Object)headers.getValue("a"));
    }

    @Test
    public void testToStringShouldBeRepresentingKeyEqualsignValue() {
        HttpHeaders headers = new HttpHeaders();
        headers.put("key1", "value1");
        headers.put("key2", "value2");
        headers.put("key3", "value3");
        Assertions.assertEquals((Object)"key1=value1, key2=value2, key3=value3", (Object)headers.toString());
    }
}

