/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Random;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.slf4j.LoggerFactory;

public class MockServer {
    public static void main(String[] args) throws Exception {
        int port = 8080;
        String portString = System.getenv("JAVA_SDK_TEST_PORT");
        if (portString != null) {
            port = Integer.parseInt(portString, 10);
        }
        Server server = new Server(port);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        String tempPath = System.getenv("JAVA_STRESS_TEST_TEMP_PATH");
        if (tempPath == null || tempPath.isEmpty()) {
            tempPath = "client-runtime/temp";
        }
        resourceHandler.setResourceBase(tempPath);
        ContextHandler ch = new ContextHandler("/javasdktest/upload");
        ch.setHandler((Handler)resourceHandler);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)ch);
        handlers.addHandler((Handler)new TestHandler());
        server.setHandler((Handler)handlers);
        System.out.println("Starting MockServer");
        server.start();
        server.join();
        System.out.println("Shutting down MockServer");
    }

    private static class TestHandler
    extends HandlerWrapper {
        private TestHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            int bytesRead;
            MessageDigest md5;
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Received request for " + baseRequest.getRequestURL());
            baseRequest.setHandled(true);
            Random random = new Random();
            byte[] buf = new byte[8192];
            ServletInputStream is = request.getInputStream();
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            while ((bytesRead = is.read(buf)) != -1) {
                md5.update(buf, 0, bytesRead);
                int randomNumber = random.nextInt(100000);
                if (randomNumber != 12345) continue;
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Server had a transient error.");
                response.setStatus(503);
                response.getWriter().println("Error! Please try again.");
                int bytes = is.read(buf);
                while (bytes != -1) {
                    bytes = is.read(buf);
                }
                return;
            }
            byte[] md5Digest = md5.digest();
            String encodedMD5 = Base64.getEncoder().encodeToString(md5Digest);
            if (request.getMethod().equals("DELETE")) {
                response.setStatus(202);
            } else {
                response.setStatus(201);
            }
            response.setHeader("Content-MD5", encodedMD5);
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Finished handling request " + baseRequest.getRequestURL());
        }
    }
}

