/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core;

import com.azure.core.util.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="TEMPORARY")
public class ConfigurationTests {
    private final String runtimeConfigurationName = "configurationAPIRuntimeFound";
    private final String runtimeConfiguration = "runtimeConfiguration";
    private final String environmentConfigurationName = "configurationAPIEnvironmentFound";
    private final String environmentConfiguration = "environmentConfiguration";
    private final String runtimeOverEnvironmentName = "configurationAPIUseRuntimeFirst";
    private final String defaultConfiguration = "defaultConfiguration";

    @Test
    public void runtimeConfigurationFound() {
        Assertions.assertNotNull((Object)Configuration.getGlobalConfiguration().get("configurationAPIRuntimeFound"));
    }

    @Test
    public void environmentConfigurationFound() {
        Assertions.assertNotNull((Object)Configuration.getGlobalConfiguration().get("configurationAPIEnvironmentFound"));
    }

    @Test
    public void configurationNotFound() {
        Assertions.assertNull((Object)Configuration.getGlobalConfiguration().get("invalidConfiguration"));
    }

    @Test
    public void runtimeConfigurationPreferredOverEnvironmentConfiguration() {
        String configurationValue = Configuration.getGlobalConfiguration().get("configurationAPIUseRuntimeFirst");
        Assertions.assertEquals((Object)"runtimeConfiguration", (Object)configurationValue);
    }

    @Test
    public void foundConfigurationPreferredOverDefault() {
        String configurationValue = (String)Configuration.getGlobalConfiguration().get("configurationAPIEnvironmentFound", (Object)"defaultConfiguration");
        Assertions.assertEquals((Object)"environmentConfiguration", (Object)configurationValue);
    }

    @Test
    public void fallbackToDefaultConfiguration() {
        String configurationValue = (String)Configuration.getGlobalConfiguration().get("invalidConfiguration", (Object)"defaultConfiguration");
        Assertions.assertEquals((Object)"defaultConfiguration", (Object)configurationValue);
    }

    @Test
    public void foundConfigurationIsConverted() {
        String configurationValue = (String)Configuration.getGlobalConfiguration().get("configurationAPIRuntimeFound", String::toUpperCase);
        Assertions.assertEquals((Object)"runtimeConfiguration".toUpperCase(), (Object)configurationValue);
    }

    @Test
    public void notFoundConfigurationIsConvertedToNull() {
        Assertions.assertNull((Object)Configuration.getGlobalConfiguration().get("invalidConfiguration", String::toUpperCase));
    }

    @Test
    public void logLevelUpdatesInstantly() {
        String initialLogLevel = Configuration.getGlobalConfiguration().get("AZURE_LOG_LEVEL");
        try {
            System.setProperty("AZURE_LOG_LEVEL", "123456789");
            Assertions.assertNotEquals((Object)initialLogLevel, (Object)Configuration.getGlobalConfiguration().get("AZURE_LOG_LEVEL"));
        }
        finally {
            if (initialLogLevel != null) {
                System.setProperty("AZURE_LOG_LEVEL", initialLogLevel);
            }
        }
    }

    @Test
    public void tracingDisabledUpdatesInstantly() {
        boolean initialTracingDisabled = Boolean.parseBoolean(Configuration.getGlobalConfiguration().get("AZURE_TRACING_DISABLED"));
        try {
            System.setProperty("AZURE_TRACING_DISABLED", Boolean.toString(!initialTracingDisabled));
            Assertions.assertNotEquals((Object)initialTracingDisabled, (Object)Configuration.getGlobalConfiguration().get("AZURE_TRACING_DISABLED"));
        }
        finally {
            System.setProperty("AZURE_TRACING_DISABLED", Boolean.toString(initialTracingDisabled));
        }
    }
}

