/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpRequestLogger;
import com.azure.core.http.policy.HttpResponseLogger;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class HttpLogOptions {
    private String applicationId = null;
    private HttpLogDetailLevel logLevel = HttpLogDetailLevel.ENVIRONMENT_HTTP_LOG_DETAIL_LEVEL;
    private Set<String> allowedHeaderNames = new HashSet<String>(DEFAULT_HEADERS_ALLOWLIST);
    private Set<String> allowedQueryParamNames = new HashSet<String>(DEFAULT_QUERY_PARAMS_ALLOWLIST);
    private boolean prettyPrintBody;
    private HttpRequestLogger requestLogger;
    private HttpResponseLogger responseLogger;
    private static final ClientLogger LOGGER = new ClientLogger(HttpLogOptions.class);
    private static final int MAX_APPLICATION_ID_LENGTH = 24;
    private static final String INVALID_APPLICATION_ID_LENGTH = "'applicationId' length cannot be greater than 24";
    private static final String INVALID_APPLICATION_ID_SPACE = "'applicationId' cannot contain spaces.";
    private static final List<String> DEFAULT_HEADERS_ALLOWLIST = Arrays.asList("x-ms-request-id", "x-ms-client-request-id", "x-ms-return-client-request-id", "traceparent", "MS-CV", "Accept", "Cache-Control", "Connection", "Content-Length", "Content-Type", "Date", "ETag", "Expires", "If-Match", "If-Modified-Since", "If-None-Match", "If-Unmodified-Since", "Last-Modified", "Pragma", "Request-Id", "Retry-After", "Server", "Transfer-Encoding", "User-Agent", "WWW-Authenticate");
    private static final List<String> DEFAULT_QUERY_PARAMS_ALLOWLIST = Collections.singletonList("api-version");

    public HttpLogDetailLevel getLogLevel() {
        return this.logLevel;
    }

    public HttpLogOptions setLogLevel(HttpLogDetailLevel logLevel) {
        this.logLevel = logLevel == null ? HttpLogDetailLevel.NONE : logLevel;
        return this;
    }

    public Set<String> getAllowedHeaderNames() {
        return this.allowedHeaderNames;
    }

    public HttpLogOptions setAllowedHeaderNames(Set<String> allowedHeaderNames) {
        this.allowedHeaderNames = allowedHeaderNames == null ? new HashSet() : allowedHeaderNames;
        return this;
    }

    public HttpLogOptions addAllowedHeaderName(String allowedHeaderName) {
        Objects.requireNonNull(allowedHeaderName);
        this.allowedHeaderNames.add(allowedHeaderName);
        return this;
    }

    public Set<String> getAllowedQueryParamNames() {
        return this.allowedQueryParamNames;
    }

    public HttpLogOptions setAllowedQueryParamNames(Set<String> allowedQueryParamNames) {
        this.allowedQueryParamNames = allowedQueryParamNames == null ? new HashSet() : allowedQueryParamNames;
        return this;
    }

    public HttpLogOptions addAllowedQueryParamName(String allowedQueryParamName) {
        this.allowedQueryParamNames.add(allowedQueryParamName);
        return this;
    }

    @Deprecated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Deprecated
    public HttpLogOptions setApplicationId(String applicationId) {
        if (!CoreUtils.isNullOrEmpty(applicationId)) {
            if (applicationId.length() > 24) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_LENGTH));
            }
            if (applicationId.contains(" ")) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_SPACE));
            }
        }
        this.applicationId = applicationId;
        return this;
    }

    public boolean isPrettyPrintBody() {
        return this.prettyPrintBody;
    }

    public HttpLogOptions setPrettyPrintBody(boolean prettyPrintBody) {
        this.prettyPrintBody = prettyPrintBody;
        return this;
    }

    public HttpRequestLogger getRequestLogger() {
        return this.requestLogger;
    }

    public HttpLogOptions setRequestLogger(HttpRequestLogger requestLogger) {
        this.requestLogger = requestLogger;
        return this;
    }

    public HttpResponseLogger getResponseLogger() {
        return this.responseLogger;
    }

    public HttpLogOptions setResponseLogger(HttpResponseLogger responseLogger) {
        this.responseLogger = responseLogger;
        return this;
    }
}

