/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.credential.AccessToken;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class SimpleTokenCache {
    private static final Duration REFRESH_DELAY = Duration.ofSeconds(30L);
    private static final Duration REFRESH_OFFSET = Duration.ofMinutes(5L);
    private final AtomicReference<Sinks.One<AccessToken>> wip;
    private volatile AccessToken cache;
    private volatile OffsetDateTime nextTokenRefresh = OffsetDateTime.now();
    private final Supplier<Mono<AccessToken>> tokenSupplier;
    private final Predicate<AccessToken> shouldRefresh;
    private final ClientLogger logger = new ClientLogger(SimpleTokenCache.class);

    public SimpleTokenCache(Supplier<Mono<AccessToken>> tokenSupplier) {
        this.wip = new AtomicReference();
        this.tokenSupplier = tokenSupplier;
        this.shouldRefresh = accessToken -> OffsetDateTime.now().isAfter(accessToken.getExpiresAt().minus(REFRESH_OFFSET));
    }

    public Mono<AccessToken> getToken() {
        return Mono.defer(() -> {
            try {
                if (this.wip.compareAndSet(null, (Sinks.One<AccessToken>)Sinks.one())) {
                    Mono fallback;
                    Mono tokenRefresh;
                    Sinks.One<AccessToken> sinksOne = this.wip.get();
                    OffsetDateTime now = OffsetDateTime.now();
                    if (this.cache != null && !this.shouldRefresh.test(this.cache)) {
                        tokenRefresh = Mono.empty();
                        fallback = Mono.just((Object)this.cache);
                    } else if (this.cache == null || this.cache.isExpired()) {
                        tokenRefresh = now.isAfter(this.nextTokenRefresh) ? Mono.defer(this.tokenSupplier) : Mono.defer(this.tokenSupplier).delaySubscription(Duration.between(now, this.nextTokenRefresh));
                        fallback = Mono.empty();
                    } else {
                        tokenRefresh = now.isAfter(this.nextTokenRefresh) ? Mono.defer(this.tokenSupplier) : Mono.empty();
                        fallback = Mono.just((Object)this.cache);
                    }
                    return tokenRefresh.materialize().flatMap(signal -> {
                        AccessToken accessToken = (AccessToken)signal.get();
                        Throwable error = signal.getThrowable();
                        if (signal.isOnNext() && accessToken != null) {
                            this.logger.info(this.refreshLog(this.cache, now, "Acquired a new access token"));
                            this.cache = accessToken;
                            sinksOne.tryEmitValue((Object)accessToken);
                            this.nextTokenRefresh = OffsetDateTime.now().plus(REFRESH_DELAY);
                            return Mono.just((Object)accessToken);
                        }
                        if (signal.isOnError() && error != null) {
                            this.logger.error(this.refreshLog(this.cache, now, "Failed to acquire a new access token"));
                            this.nextTokenRefresh = OffsetDateTime.now().plus(REFRESH_DELAY);
                            return fallback.switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)error)));
                        }
                        sinksOne.tryEmitEmpty();
                        return fallback;
                    }).doOnError(arg_0 -> sinksOne.tryEmitError(arg_0)).doOnTerminate(() -> this.wip.set(null));
                }
                if (this.cache != null && !this.cache.isExpired()) {
                    return Mono.just((Object)this.cache);
                }
                Sinks.One<AccessToken> sinksOne = this.wip.get();
                if (sinksOne == null) {
                    return Mono.just((Object)this.cache);
                }
                return sinksOne.asMono().switchIfEmpty(Mono.defer(() -> Mono.just((Object)this.cache)));
            }
            catch (Throwable t) {
                return Mono.error((Throwable)t);
            }
        });
    }

    private String refreshLog(AccessToken cache, OffsetDateTime now, String log) {
        StringBuilder info = new StringBuilder(log);
        if (cache == null) {
            info.append(".");
        } else {
            Duration tte = Duration.between(now, cache.getExpiresAt());
            info.append(" at ").append(tte.abs().getSeconds()).append(" seconds ").append(tte.isNegative() ? "after" : "before").append(" expiry. ").append("Retry may be attempted after ").append(REFRESH_DELAY.getSeconds()).append(" seconds.");
            if (!tte.isNegative()) {
                info.append(" The token currently cached will be used.");
            }
        }
        return info.toString();
    }
}

