/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.RedirectStrategy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class DefaultRedirectStrategy
implements RedirectStrategy {
    private final ClientLogger logger = new ClientLogger(DefaultRedirectStrategy.class);
    private static final int DEFAULT_MAX_REDIRECT_ATTEMPTS = 3;
    private static final String DEFAULT_REDIRECT_LOCATION_HEADER_NAME = "Location";
    private static final int PERMANENT_REDIRECT_STATUS_CODE = 308;
    private static final int TEMPORARY_REDIRECT_STATUS_CODE = 307;
    private static final Set<HttpMethod> DEFAULT_REDIRECT_ALLOWED_METHODS = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.HEAD));
    private final int maxAttempts;
    private final String locationHeader;
    private final Set<HttpMethod> allowedRedirectHttpMethods;

    public DefaultRedirectStrategy() {
        this(3, DEFAULT_REDIRECT_LOCATION_HEADER_NAME, DEFAULT_REDIRECT_ALLOWED_METHODS);
    }

    public DefaultRedirectStrategy(int maxAttempts) {
        this(maxAttempts, DEFAULT_REDIRECT_LOCATION_HEADER_NAME, DEFAULT_REDIRECT_ALLOWED_METHODS);
    }

    public DefaultRedirectStrategy(int maxAttempts, String locationHeader, Set<HttpMethod> allowedMethods) {
        if (maxAttempts < 0) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Max attempts cannot be less than 0."));
        }
        this.maxAttempts = maxAttempts;
        if (CoreUtils.isNullOrEmpty(locationHeader)) {
            this.logger.error("'locationHeader' provided as null will be defaulted to {}", DEFAULT_REDIRECT_LOCATION_HEADER_NAME);
            this.locationHeader = DEFAULT_REDIRECT_LOCATION_HEADER_NAME;
        } else {
            this.locationHeader = locationHeader;
        }
        if (CoreUtils.isNullOrEmpty(allowedMethods)) {
            this.logger.error("'allowedMethods' provided as null will be defaulted to {}", DEFAULT_REDIRECT_ALLOWED_METHODS);
            this.allowedRedirectHttpMethods = DEFAULT_REDIRECT_ALLOWED_METHODS;
        } else {
            this.allowedRedirectHttpMethods = allowedMethods;
        }
    }

    @Override
    public boolean shouldAttemptRedirect(HttpPipelineCallContext context, HttpResponse httpResponse, int tryCount, Set<String> attemptedRedirectUrls) {
        String redirectUrl = this.tryGetRedirectHeader(httpResponse.getHeaders(), this.getLocationHeader());
        if (this.isValidRedirectCount(tryCount) && redirectUrl != null && !this.alreadyAttemptedRedirectUrl(redirectUrl, attemptedRedirectUrls) && this.isValidRedirectStatusCode(httpResponse.getStatusCode()) && this.isAllowedRedirectMethod(httpResponse.getRequest().getHttpMethod())) {
            this.logger.verbose("[Redirecting] Try count: {}, Attempted Redirect URLs: {}", tryCount, attemptedRedirectUrls.toString());
            attemptedRedirectUrls.add(redirectUrl);
            return true;
        }
        return false;
    }

    @Override
    public HttpRequest createRedirectRequest(HttpResponse httpResponse) {
        String responseLocation = this.tryGetRedirectHeader(httpResponse.getHeaders(), this.getLocationHeader());
        return httpResponse.getRequest().setUrl(responseLocation);
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    String getLocationHeader() {
        return this.locationHeader;
    }

    Set<HttpMethod> getAllowedRedirectHttpMethods() {
        return this.allowedRedirectHttpMethods;
    }

    private boolean alreadyAttemptedRedirectUrl(String redirectUrl, Set<String> attemptedRedirectUrls) {
        if (attemptedRedirectUrls.contains(redirectUrl)) {
            this.logger.error("Request was redirected more than once to: {}", redirectUrl);
            return true;
        }
        return false;
    }

    private boolean isValidRedirectCount(int tryCount) {
        if (tryCount >= this.getMaxAttempts()) {
            this.logger.error("Request has been redirected more than {} times.", this.getMaxAttempts());
            return false;
        }
        return true;
    }

    private boolean isAllowedRedirectMethod(HttpMethod httpMethod) {
        if (this.getAllowedRedirectHttpMethods().contains((Object)httpMethod)) {
            return true;
        }
        this.logger.error("Request was redirected from an invalid redirect allowed method: {}", new Object[]{httpMethod});
        return false;
    }

    private boolean isValidRedirectStatusCode(int statusCode) {
        return statusCode == 302 || statusCode == 301 || statusCode == 308 || statusCode == 307;
    }

    String tryGetRedirectHeader(HttpHeaders headers, String headerName) {
        String headerValue = headers.getValue(headerName);
        if (CoreUtils.isNullOrEmpty(headerValue)) {
            this.logger.error("Redirect url was null for header name: {}, request redirect was terminated.", headerName);
            return null;
        }
        return headerValue;
    }
}

