/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils.metrics;

import com.azure.core.test.utils.metrics.TestCounter;
import com.azure.core.test.utils.metrics.TestGauge;
import com.azure.core.test.utils.metrics.TestHistogram;
import com.azure.core.test.utils.metrics.TestTelemetryAttributes;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.metrics.DoubleHistogram;
import com.azure.core.util.metrics.LongCounter;
import com.azure.core.util.metrics.LongGauge;
import com.azure.core.util.metrics.Meter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TestMeter
implements Meter {
    private final Map<String, TestHistogram> histograms = new ConcurrentHashMap<String, TestHistogram>();
    private final Map<String, TestCounter> counters = new ConcurrentHashMap<String, TestCounter>();
    private final Map<String, TestGauge> gauges = new ConcurrentHashMap<String, TestGauge>();
    private final Map<String, TestCounter> upDownCounters = new ConcurrentHashMap<String, TestCounter>();
    private final boolean isEnabled;

    public TestMeter() {
        this(true);
    }

    public TestMeter(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public DoubleHistogram createDoubleHistogram(String name, String description, String unit) {
        return this.histograms.computeIfAbsent(name, n -> new TestHistogram(this.isEnabled));
    }

    public LongCounter createLongCounter(String name, String description, String unit) {
        return this.counters.computeIfAbsent(name, n -> new TestCounter(this.isEnabled));
    }

    public LongCounter createLongUpDownCounter(String name, String description, String unit) {
        return this.upDownCounters.computeIfAbsent(name, n -> new TestCounter(this.isEnabled));
    }

    public LongGauge createLongGauge(String name, String description, String unit) {
        return this.gauges.computeIfAbsent(name, n -> new TestGauge(this.isEnabled));
    }

    public TelemetryAttributes createAttributes(Map<String, Object> attributeMap) {
        return new TestTelemetryAttributes(attributeMap);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void close() {
    }

    public Map<String, TestHistogram> getHistograms() {
        return this.histograms;
    }

    public Map<String, TestCounter> getCounters() {
        return this.counters;
    }

    public Map<String, TestCounter> getUpDownCounters() {
        return this.upDownCounters;
    }

    public Map<String, TestGauge> getGauges() {
        return this.gauges;
    }
}

