/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.util.CoreUtils;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;

public class ResourceNamer {
    private static final Locale LOCALE = Locale.US;
    private final String randName;

    public ResourceNamer(String name) {
        this.randName = name.toLowerCase(LOCALE) + CoreUtils.randomUuid().toString().replace("-", "").substring(0, 3).toLowerCase(LOCALE);
    }

    public String randomName(String prefix, int maxLen) {
        prefix = prefix.toLowerCase(LOCALE);
        int minRandomnessLength = 5;
        if (maxLen <= minRandomnessLength) {
            return this.randomString(maxLen);
        }
        if (maxLen < prefix.length() + minRandomnessLength) {
            return this.randomString(maxLen);
        }
        String minRandomString = String.format("%05d", Math.abs(ThreadLocalRandom.current().nextInt() % 100000));
        if (maxLen <= prefix.length() + this.randName.length() + minRandomnessLength) {
            String str = prefix + minRandomString;
            return str + this.randomString((maxLen - str.length()) / 2);
        }
        String str = prefix + this.randName + minRandomString;
        return str + this.randomString((maxLen - str.length()) / 2);
    }

    public String randomUuid() {
        return CoreUtils.randomUuid().toString();
    }

    private String randomString(int length) {
        StringBuilder str = new StringBuilder();
        while (str.length() < length) {
            str.append(CoreUtils.randomUuid().toString().replace("-", "").substring(0, Math.min(32, length)).toLowerCase(LOCALE));
        }
        return str.toString();
    }
}

