/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.implementation.polling;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

class Error
implements JsonSerializable<Error> {
    @JsonProperty(value="error")
    private String message;
    @JsonProperty(value="responseStatusCode")
    private int responseStatusCode;
    @JsonProperty(value="responseBody")
    private String responseBody;
    @JsonProperty(value="responseHeaders")
    private Map<String, String> responseHeaders;

    Error() {
    }

    Error(String message, int responseStatusCode, Map<String, String> responseHeaders, String responseBody) {
        this.message = Objects.requireNonNull(message, "'message' cannot be null.");
        this.responseStatusCode = responseStatusCode;
        this.responseBody = responseBody;
        this.responseHeaders = responseHeaders;
    }

    String getMessage() {
        return this.message;
    }

    int getResponseStatusCode() {
        return this.responseStatusCode;
    }

    String getResponseBody() {
        return this.responseBody;
    }

    Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("error", this.message).writeIntField("responseStatusCode", this.responseStatusCode).writeStringField("responseBody", this.responseBody).writeMapField("responseHeaders", this.responseHeaders, JsonWriter::writeString).writeEndObject();
    }

    public static Error fromJson(JsonReader jsonReader) throws IOException {
        return (Error)jsonReader.readObject(reader -> {
            Error error = new Error();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("error".equals(fieldName)) {
                    error.message = reader.getString();
                    continue;
                }
                if ("responseStatusCode".equals(fieldName)) {
                    error.responseStatusCode = reader.getInt();
                    continue;
                }
                if ("responseBody".equals(fieldName)) {
                    error.responseBody = reader.getString();
                    continue;
                }
                if ("responseHeaders".equals(fieldName)) {
                    error.responseHeaders = reader.readMap(JsonReader::getString);
                    continue;
                }
                reader.skipChildren();
            }
            return error;
        });
    }
}

