/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncResponseBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import okhttp3.Response;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class OkHttpAsyncBufferedResponse
extends OkHttpAsyncResponseBase {
    private final byte[] body;

    public OkHttpAsyncBufferedResponse(Response response, HttpRequest request, byte[] body) {
        super(response, request);
        this.body = body;
    }

    public Flux<ByteBuffer> getBody() {
        return Flux.defer(() -> Flux.just((Object)ByteBuffer.wrap(this.body)));
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.defer(() -> Mono.just((Object)this.body));
    }

    public Mono<InputStream> getBodyAsInputStream() {
        return Mono.defer(() -> Mono.just((Object)new ByteArrayInputStream(this.body)));
    }

    public HttpResponse buffer() {
        return this;
    }
}

