/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.util.ProgressReporter;
import java.io.IOException;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public final class OkHttpProgressReportingRequestBody
extends RequestBody {
    private final RequestBody delegate;
    private final ProgressReporter progressReporter;

    public OkHttpProgressReportingRequestBody(RequestBody delegate, ProgressReporter progressReporter) {
        this.delegate = Objects.requireNonNull(delegate, "'delegate' must not be null");
        this.progressReporter = Objects.requireNonNull(progressReporter, "'progressReporter' must not be null");
    }

    public MediaType contentType() {
        return this.delegate.contentType();
    }

    public long contentLength() throws IOException {
        return this.delegate.contentLength();
    }

    public boolean isOneShot() {
        return this.delegate.isOneShot();
    }

    public boolean isDuplex() {
        return this.delegate.isDuplex();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        CountingSink countingSink = new CountingSink((Sink)sink, this.progressReporter);
        BufferedSink bufferedSink = Okio.buffer((Sink)countingSink);
        this.delegate.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    private static final class CountingSink
    extends ForwardingSink {
        private final ProgressReporter progressReporter;

        CountingSink(Sink delegate, ProgressReporter progressReporter) {
            super(delegate);
            this.progressReporter = progressReporter;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            this.progressReporter.reportProgress(byteCount);
        }
    }
}

