/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.models;

import com.azure.core.amqp.AmqpTransaction;
import com.azure.core.amqp.models.DeliveryOutcome;
import com.azure.core.amqp.models.DeliveryState;
import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class TransactionalDeliveryOutcome
extends DeliveryOutcome {
    private static final ClientLogger LOGGER = new ClientLogger(TransactionalDeliveryOutcome.class);
    private final AmqpTransaction amqpTransaction;
    private DeliveryOutcome outcome;

    public TransactionalDeliveryOutcome(AmqpTransaction transaction) {
        super(DeliveryState.TRANSACTIONAL);
        this.amqpTransaction = Objects.requireNonNull(transaction, "'transaction' cannot be null.");
    }

    public ByteBuffer getTransactionId() {
        return this.amqpTransaction.getTransactionId();
    }

    public DeliveryOutcome getOutcome() {
        return this.outcome;
    }

    public TransactionalDeliveryOutcome setOutcome(DeliveryOutcome outcome) {
        if (outcome instanceof TransactionalDeliveryOutcome) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot set the outcome as another nested transaction outcome."));
        }
        this.outcome = outcome;
        return this;
    }
}

