/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.implementation.AmqpLoggingUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.reactor.Reactor;

public class ReactorHandler
extends BaseHandler {
    private static final int REACTOR_IO_POLL_TIMEOUT = 20;
    private final ClientLogger logger;

    public ReactorHandler(String connectionId) {
        Objects.requireNonNull(connectionId);
        this.logger = new ClientLogger(ReactorHandler.class, AmqpLoggingUtils.createContextWithConnectionId(connectionId));
    }

    public void onReactorInit(Event e) {
        this.logger.info("reactor.onReactorInit");
        Reactor reactor = e.getReactor();
        reactor.setTimeout(20L);
    }

    public void onReactorFinal(Event e) {
        this.logger.atInfo().addKeyValue("event", (Object)e).log("reactor.onReactorFinal.");
    }
}

