/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.implementation.AmqpReceiveLink;
import com.azure.core.amqp.implementation.CreditAccountingStrategy;
import com.azure.core.util.logging.ClientLogger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscription;

final class EmissionDrivenCreditAccountingStrategy
extends CreditAccountingStrategy {
    private static final int MAX_INT_PREFETCH_BOUND = 100;
    private boolean placedInitialCredit;
    private final int limit;
    private final AtomicLong emissionAccumulated = new AtomicLong(0L);

    EmissionDrivenCreditAccountingStrategy(AmqpReceiveLink receiver, Subscription subscription, int prefetch, ClientLogger logger) {
        super(receiver, subscription, EmissionDrivenCreditAccountingStrategy.validateAndGet(prefetch, logger), logger);
        this.limit = this.prefetch - (this.prefetch >> 1);
    }

    @Override
    void update(long request, long emitted) {
        if (emitted != 0L) {
            this.subscription.request(emitted);
            if (this.emissionAccumulated.addAndGet(emitted) >= (long)this.limit) {
                this.scheduleCredit(() -> this.emissionAccumulated.getAndSet(0L));
            }
        } else if (!this.placedInitialCredit) {
            this.placedInitialCredit = true;
            this.subscription.request((long)this.prefetch);
            this.scheduleCredit(() -> this.prefetch);
        }
    }

    private static int validateAndGet(int prefetch, ClientLogger logger) {
        if (prefetch <= 0) {
            throw logger.atInfo().log((RuntimeException)new IllegalArgumentException("prefetch >= 1 required but it was " + prefetch));
        }
        return prefetch == Integer.MAX_VALUE ? 100 : prefetch;
    }
}

