/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp;

import com.azure.core.amqp.AmqpEndpointState;
import com.azure.core.amqp.AmqpLink;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.AmqpTransaction;
import com.azure.core.amqp.AmqpTransactionCoordinator;
import com.azure.core.util.AsyncCloseable;
import java.time.Duration;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface AmqpSession
extends Disposable,
AsyncCloseable {
    public String getSessionName();

    public Duration getOperationTimeout();

    public Mono<AmqpLink> createProducer(String var1, String var2, Duration var3, AmqpRetryPolicy var4);

    public Mono<AmqpLink> createConsumer(String var1, String var2, Duration var3, AmqpRetryPolicy var4);

    public boolean removeLink(String var1);

    public Flux<AmqpEndpointState> getEndpointStates();

    public Mono<AmqpTransaction> createTransaction();

    public Mono<Void> commitTransaction(AmqpTransaction var1);

    public Mono<Void> rollbackTransaction(AmqpTransaction var1);

    default public Mono<? extends AmqpTransactionCoordinator> getOrCreateTransactionCoordinator() {
        return Mono.error((Throwable)new UnsupportedOperationException("Implementation not found error."));
    }

    default public Mono<Void> closeAsync() {
        return Mono.fromRunnable(() -> this.dispose());
    }
}

